## ----setup, include=FALSE,echo=FALSE------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    cache = TRUE,
    out.width = "100%"
)
imageTCGAimagePath <- function(name, branch = "devel") {
    if (curl::has_internet())
        glue::glue(
            "https://github.com/billila/imageTCGA/blob/{branch}",
            "/vignettes/figures/{name}?raw=true"
        )
    else
        glue::glue("figures/{name}")
}

## ----eval=FALSE---------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("imageTCGA")

## ----include=TRUE, results="hide", message=FALSE, warning=FALSE---------------
library(imageTCGA)

## ----eval=FALSE---------------------------------------------------------------
# imageTCGA::imageTCGA()

## ----echo=FALSE, fig.wide = TRUE----------------------------------------------
knitr::include_graphics(imageTCGAimagePath("imageTCGA_shiny.png"))

## ----echo=FALSE,fig.wide = TRUE-----------------------------------------------
knitr::include_graphics(imageTCGAimagePath("imageTCGA_shiny_OV.png"))

## ----echo=FALSE,fig.wide = TRUE-----------------------------------------------
knitr::include_graphics(imageTCGAimagePath("imageTCGA_shiny_OV_Rcode.png"))

## ----echo=FALSE,fig.wide = TRUE-----------------------------------------------
knitr::include_graphics(imageTCGAimagePath("imageTCGA_shiny_dotplot.png"))

## ----echo=FALSE,fig.wide = TRUE-----------------------------------------------
knitr::include_graphics(imageTCGAimagePath("imageTCGA_shiny_worldmap_GBM.png"))

## -----------------------------------------------------------------------------
sessionInfo()

