## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval=FALSE---------------------------------------------------------------
# BiocManager::install("FinfoMDS")

## ----eval=FALSE---------------------------------------------------------------
# devtools::install_github("soob-kim/FinfoMDS")

## ----eval = TRUE--------------------------------------------------------------
library(FinfoMDS)
data("microbiome", package = "FinfoMDS")

## ----eval = TRUE--------------------------------------------------------------
require(phyloseq)
D <- distance(microbiome, method = 'wunifrac') # requires phyloseq package
y <- sample_data(microbiome)$Treatment

## ----eval = TRUE--------------------------------------------------------------
result <- fmds(D = D, y = y, lambda = 0.3, threshold_p = 0.05)

## ----eval = TRUE--------------------------------------------------------------
plot(result, pch = y)

## -----------------------------------------------------------------------------
sessionInfo()

