/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.ChromHMM;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.tc33.jheatchart.HeatChart;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class Util {
    static BufferedReader getBufferedReader(String string) throws IOException {
        BufferedReader bufferedReader;
        if (string.endsWith(".gz")) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string))));
            }
            catch (IOException iOException) {
                System.out.println("IOException thrown for file " + string);
                throw iOException;
            }
        } else {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        return bufferedReader;
    }

    static double euclid(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += (dArray[i] - dArray2[i]) * (dArray[i] - dArray2[i]);
        }
        return Math.sqrt(d);
    }

    static double correlation(double[] dArray, double[] dArray2) {
        double d;
        double d2;
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            d4 += dArray[i];
            d5 += dArray2[i];
            d6 += dArray[i] * dArray[i];
            d7 += dArray2[i] * dArray2[i];
            d8 += dArray[i] * dArray2[i];
        }
        n = dArray.length;
        double d9 = n == 0 ? 0.0 : ((d3 = (d2 = d6 - d4 * d4 / (double)n) * (d = d7 - d5 * d5 / (double)n)) <= 0.0 ? 0.0 : (d8 - d4 * d5 / (double)n) / Math.sqrt(d3));
        return d9;
    }

    static void printImageToSVG(HeatChart heatChart, String string) throws IOException {
        File file = new File(string);
        heatChart.getChartImage();
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        String string2 = "http://www.w3.org/2000/svg";
        Document document = dOMImplementation.createDocument(string2, "svg", null);
        SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault(document);
        sVGGeneratorContext.setEmbeddedFontsOn(true);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(sVGGeneratorContext, true);
        sVGGraphics2D.setColor(Color.white);
        heatChart.getChartGraphics(sVGGraphics2D);
        boolean bl = true;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        sVGGraphics2D.stream(outputStreamWriter, bl);
    }
}

