﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/storagegateway/StorageGatewayRequest.h>
#include <aws/storagegateway/StorageGateway_EXPORTS.h>

#include <utility>

namespace Aws {
namespace StorageGateway {
namespace Model {

/**
 */
class UpdateSMBFileShareVisibilityRequest : public StorageGatewayRequest {
 public:
  AWS_STORAGEGATEWAY_API UpdateSMBFileShareVisibilityRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateSMBFileShareVisibility"; }

  AWS_STORAGEGATEWAY_API Aws::String SerializePayload() const override;

  AWS_STORAGEGATEWAY_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{

  inline const Aws::String& GetGatewayARN() const { return m_gatewayARN; }
  inline bool GatewayARNHasBeenSet() const { return m_gatewayARNHasBeenSet; }
  template <typename GatewayARNT = Aws::String>
  void SetGatewayARN(GatewayARNT&& value) {
    m_gatewayARNHasBeenSet = true;
    m_gatewayARN = std::forward<GatewayARNT>(value);
  }
  template <typename GatewayARNT = Aws::String>
  UpdateSMBFileShareVisibilityRequest& WithGatewayARN(GatewayARNT&& value) {
    SetGatewayARN(std::forward<GatewayARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The shares on this gateway appear when listing shares.</p>
   */
  inline bool GetFileSharesVisible() const { return m_fileSharesVisible; }
  inline bool FileSharesVisibleHasBeenSet() const { return m_fileSharesVisibleHasBeenSet; }
  inline void SetFileSharesVisible(bool value) {
    m_fileSharesVisibleHasBeenSet = true;
    m_fileSharesVisible = value;
  }
  inline UpdateSMBFileShareVisibilityRequest& WithFileSharesVisible(bool value) {
    SetFileSharesVisible(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_gatewayARN;
  bool m_gatewayARNHasBeenSet = false;

  bool m_fileSharesVisible{false};
  bool m_fileSharesVisibleHasBeenSet = false;
};

}  // namespace Model
}  // namespace StorageGateway
}  // namespace Aws
