/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBConfigurationController;
import org.jkiss.dbeaver.model.DBFileController;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPApplicationConfigurator;
import org.jkiss.dbeaver.model.app.DBPDataFormatterRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguageManager;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.data.DBDRegistry;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.fs.DBFRegistry;
import org.jkiss.dbeaver.model.impl.preferences.AbstractPreferenceStore;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.net.DBWHandlerRegistry;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadataRegistry;
import org.jkiss.dbeaver.model.task.DBTTaskController;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.LocalConfigurationController;
import org.jkiss.dbeaver.registry.LocalFileController;
import org.jkiss.dbeaver.registry.LocalTaskController;
import org.jkiss.dbeaver.registry.ObjectManagerRegistry;
import org.jkiss.dbeaver.registry.PluginServiceRegistry;
import org.jkiss.dbeaver.registry.datatype.DataTypeProviderRegistry;
import org.jkiss.dbeaver.registry.formatter.DataFormatterRegistry;
import org.jkiss.dbeaver.registry.fs.FileSystemProviderRegistry;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.registry.settings.GlobalSettings;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.runtime.jobs.DataSourceMonitorJob;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public abstract class BasePlatformImpl
implements DBPPlatform,
DBPApplicationConfigurator,
DBPPlatformLanguageManager {
    private static final Log log = Log.getLog(BasePlatformImpl.class);
    public static final String DBEAVER_DATA_DIR = "DBeaverData";
    private static final String APP_CONFIG_FILE = "dbeaver.ini";
    private static final String ECLIPSE_CONFIG_FILE = "eclipse.ini";
    public static final String CONFIG_FOLDER = ".config";
    public static final String FILES_FOLDER = ".files";
    private static final String DBEAVER_PROP_LANGUAGE = "nl";
    protected OSDescriptor localSystem;
    private DBNModel navigatorModel;
    private final List<IPluginService> activatedServices = new ArrayList<IPluginService>();
    private DBFileController localFileController;
    private DBTTaskController localTaskController;
    private DBConfigurationController defaultConfigurationController;
    private final Map<Bundle, DBConfigurationController> configurationControllerByPlugin = new HashMap<Bundle, DBConfigurationController>();
    private SQLDialectMetadataRegistry sqlDialectRegistry;
    private DBPPlatformLanguage platformLanguage;

    protected void initialize() {
        log.debug((Object)"Initialize base platform...");
        DBPPreferenceStore prefStore = this.getPreferenceStore();
        prefStore.addPropertyChangeListener(event -> {
            for (DBPDataSourceContainer ds : DataSourceRegistry.getAllDataSources()) {
                ((AbstractPreferenceStore)ds.getPreferenceStore()).firePropertyChangeEvent((Object)prefStore, event.getProperty(), event.getOldValue(), event.getNewValue());
            }
        });
        this.platformLanguage = PlatformLanguageRegistry.getInstance().getLanguage(Locale.getDefault());
        if (this.platformLanguage == null) {
            log.debug((Object)("Language for locale '" + String.valueOf(Locale.getDefault()) + "' not found. Use default."));
            this.platformLanguage = PlatformLanguageRegistry.getInstance().getLanguage(Locale.ENGLISH);
        }
        this.navigatorModel = this.createNavigatorModel();
        this.navigatorModel.setModelAuthContext(this.getWorkspace().getAuthContext());
        this.navigatorModel.initialize();
        if (!this.getApplication().isExclusiveMode()) {
            this.activatePluginServices();
            if (!this.getApplication().isMultiuser()) {
                new DataSourceMonitorJob((DBPPlatform)this).scheduleMonitor();
            }
        }
    }

    protected DBNModel createNavigatorModel() {
        return new DBNModel((DBPPlatform)this, null);
    }

    protected void activatePluginServices() {
        for (IPluginService pluginService : PluginServiceRegistry.getInstance().getServices()) {
            try {
                pluginService.activateService();
                this.activatedServices.add(pluginService);
            }
            catch (Throwable e) {
                log.error((Object)"Error activating plugin service", e);
            }
        }
    }

    public synchronized void dispose() {
        for (IPluginService pluginService : this.activatedServices) {
            try {
                pluginService.deactivateService();
            }
            catch (Exception e) {
                log.error((Object)"Error deactivating plugin service", (Throwable)e);
            }
        }
        this.activatedServices.clear();
        this.disposeNavigatorModel();
    }

    public void disposeNavigatorModel() {
        if (this.navigatorModel != null && this.navigatorModel.getRoot() != null) {
            log.debug((Object)"Dispose navigator model");
            this.navigatorModel.dispose();
        }
    }

    @NotNull
    public DBDRegistry getValueHandlerRegistry() {
        return DataTypeProviderRegistry.getInstance();
    }

    @NotNull
    public DBERegistry getEditorsRegistry() {
        return ObjectManagerRegistry.getInstance();
    }

    @NotNull
    public DBFRegistry getFileSystemRegistry() {
        return FileSystemProviderRegistry.getInstance();
    }

    @NotNull
    public SQLDialectMetadataRegistry getSQLDialectRegistry() {
        if (this.sqlDialectRegistry == null) {
            this.sqlDialectRegistry = (SQLDialectMetadataRegistry)RuntimeUtils.getBundleService(SQLDialectMetadataRegistry.class, (boolean)true);
            if (this.sqlDialectRegistry == null) {
                throw new IllegalStateException("Cannot determine SQL dialect registry for " + String.valueOf(this.getClass()));
            }
        }
        return this.sqlDialectRegistry;
    }

    @NotNull
    public DBWHandlerRegistry getNetworkHandlerRegistry() {
        return NetworkHandlerRegistry.getInstance();
    }

    @NotNull
    public DBConfigurationController getConfigurationController() {
        return this.getPluginConfigurationController(null);
    }

    @NotNull
    public DBConfigurationController getProductConfigurationController() {
        return this.getConfigurationController(this.getProductPlugin().getBundle());
    }

    @NotNull
    public DBConfigurationController getPluginConfigurationController(@Nullable String pluginId) {
        return this.getConfigurationController(CommonUtils.isEmpty((String)pluginId) ? null : Platform.getBundle((String)pluginId));
    }

    private DBConfigurationController getConfigurationController(@Nullable Bundle bundle) {
        DBConfigurationController controller;
        DBConfigurationController dBConfigurationController = controller = bundle == null ? this.defaultConfigurationController : this.configurationControllerByPlugin.get(bundle);
        if (controller == null) {
            controller = this.createConfigurationController(bundle);
            if (bundle == null) {
                this.defaultConfigurationController = controller;
            } else {
                this.configurationControllerByPlugin.put(bundle, controller);
            }
        }
        return controller;
    }

    @NotNull
    public DBConfigurationController createConfigurationController(@Nullable String pluginId) {
        return this.createConfigurationController(pluginId == null ? null : Platform.getBundle((String)pluginId));
    }

    @NotNull
    private DBConfigurationController createConfigurationController(@Nullable Bundle bundle) {
        DBPApplication application = this.getApplication();
        if (application instanceof DBPApplicationConfigurator) {
            String pluginBundleName = bundle == null ? null : bundle.getSymbolicName();
            return ((DBPApplicationConfigurator)application).createConfigurationController(pluginBundleName);
        }
        if (bundle == null) {
            Path pluginStateLocation;
            LocalConfigurationController controller = new LocalConfigurationController(this.getLocalWorkspaceConfigFolder());
            Plugin productPlugin = this.getProductPlugin();
            if (productPlugin != null && Files.exists(pluginStateLocation = RuntimeUtils.getPluginStateLocation((Plugin)productPlugin), new LinkOption[0])) {
                controller.setLegacyConfigFolder(pluginStateLocation);
            }
            return controller;
        }
        return new LocalConfigurationController(Platform.getStateLocation((Bundle)bundle).toFile().toPath());
    }

    @NotNull
    private Path getLocalWorkspaceConfigFolder() {
        return this.getWorkspace().getMetadataFolder().resolve(CONFIG_FOLDER);
    }

    @NotNull
    public DBFileController getFileController() {
        if (this.localFileController == null) {
            this.localFileController = this.createFileController();
        }
        return this.localFileController;
    }

    @NotNull
    public DBFileController createFileController() {
        DBPApplication application = this.getApplication();
        if (application instanceof DBPApplicationConfigurator) {
            return ((DBPApplicationConfigurator)application).createFileController();
        }
        return new LocalFileController(this.getWorkspace().getMetadataFolder().resolve(FILES_FOLDER));
    }

    @NotNull
    public Path getLocalConfigurationFile(String fileName) {
        Path productPluginPath = RuntimeUtils.getPluginStateLocation((Plugin)this.getProductPlugin()).resolve(fileName);
        if (Files.exists(productPluginPath, new LinkOption[0])) {
            return productPluginPath;
        }
        return this.getLocalWorkspaceConfigFolder().resolve(fileName);
    }

    @NotNull
    public DBTTaskController getTaskController() {
        if (this.localTaskController == null) {
            this.localTaskController = this.createTaskController();
        }
        return this.localTaskController;
    }

    @NotNull
    public DBTTaskController createTaskController() {
        DBPApplication application = this.getApplication();
        if (application instanceof DBPApplicationConfigurator) {
            return ((DBPApplicationConfigurator)application).createTaskController();
        }
        return new LocalTaskController();
    }

    protected abstract Plugin getProductPlugin();

    @NotNull
    public Path getApplicationConfiguration() {
        Path configPath;
        try {
            configPath = RuntimeUtils.getLocalPathFromURL((URL)Platform.getInstallLocation().getURL());
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't detect application installation folder.", e);
        }
        Path iniFile = configPath.resolve(ECLIPSE_CONFIG_FILE);
        if (!Files.exists(iniFile, new LinkOption[0])) {
            iniFile = configPath.resolve(APP_CONFIG_FILE);
        }
        return iniFile;
    }

    @NotNull
    public DBPDataFormatterRegistry getDataFormatterRegistry() {
        return DataFormatterRegistry.getInstance();
    }

    @NotNull
    public OSDescriptor getLocalSystem() {
        if (this.localSystem == null) {
            this.localSystem = new OSDescriptor(Platform.getOS(), Platform.getOSArch());
        }
        return this.localSystem;
    }

    @NotNull
    public DBNModel getNavigatorModel() {
        return this.navigatorModel;
    }

    @NotNull
    public DBPDataSourceProviderRegistry getDataSourceProviderRegistry() {
        return DataSourceProviderRegistry.getInstance();
    }

    @NotNull
    public DBPPlatformLanguage getPlatformLanguage() {
        return this.platformLanguage;
    }

    public void setPlatformLanguage(@NotNull DBPPlatformLanguage language) throws DBException {
        if (CommonUtils.equalObjects((Object)language, (Object)this.platformLanguage)) {
            return;
        }
        GlobalSettings.getInstance().setGlobalProperty(DBEAVER_PROP_LANGUAGE, language.getCode());
        this.platformLanguage = language;
        this.getPreferenceStore().setValue("platform.language", language.getCode());
    }
}

