/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.opennlp.SentenceAttributeExtractor;
import org.apache.lucene.analysis.opennlp.tools.NLPPOSTaggerOp;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.SentenceAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.IgnoreRandomChains;

@IgnoreRandomChains(reason="LUCENE-10352: add argument providers for this one")
public final class OpenNLPPOSFilter
extends TokenFilter {
    private int tokenNum = 0;
    private final NLPPOSTaggerOp posTaggerOp;
    private final SentenceAttributeExtractor sentenceAttributeExtractor;

    public OpenNLPPOSFilter(TokenStream input, NLPPOSTaggerOp posTaggerOp) {
        super(input);
        this.posTaggerOp = posTaggerOp;
        this.sentenceAttributeExtractor = new SentenceAttributeExtractor(input, (SentenceAttribute)this.addAttribute(SentenceAttribute.class));
    }

    public boolean incrementToken() throws IOException {
        boolean isEndOfCurrentSentence;
        List<AttributeSource> sentenceTokenAttrs = this.sentenceAttributeExtractor.getSentenceAttributes();
        boolean bl = isEndOfCurrentSentence = this.tokenNum >= sentenceTokenAttrs.size();
        if (isEndOfCurrentSentence) {
            boolean noSentencesLeft;
            boolean bl2 = noSentencesLeft = this.sentenceAttributeExtractor.allSentencesProcessed() || this.nextSentence().isEmpty();
            if (noSentencesLeft) {
                return false;
            }
        }
        this.clearAttributes();
        sentenceTokenAttrs.get(this.tokenNum++).copyTo((AttributeSource)this);
        return true;
    }

    private List<AttributeSource> nextSentence() throws IOException {
        this.tokenNum = 0;
        ArrayList<String> termList = new ArrayList<String>();
        for (AttributeSource attributeSource : this.sentenceAttributeExtractor.extractSentenceAttributes()) {
            termList.add(((CharTermAttribute)attributeSource.getAttribute(CharTermAttribute.class)).toString());
        }
        String[] sentenceTerms = termList.toArray(new String[0]);
        this.assignTokenTypes(this.posTaggerOp.getPOSTags(sentenceTerms));
        return this.sentenceAttributeExtractor.getSentenceAttributes();
    }

    private void assignTokenTypes(String[] tags) {
        for (int i = 0; i < tags.length; ++i) {
            ((TypeAttribute)this.sentenceAttributeExtractor.getSentenceAttributes().get(i).getAttribute(TypeAttribute.class)).setType(tags[i]);
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.sentenceAttributeExtractor.reset();
        this.clear();
    }

    private void clear() {
        this.tokenNum = 0;
    }
}

