/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.actions;

import org.netbeans.modules.profiler.api.EditorSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.nbimpl.actions.Bundle;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;

public final class ProfileClassEditorAction
extends NodeAction {
    public String getName() {
        return Bundle.ProfileClassEditorAction_Name();
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    protected void performAction(final Node[] nodes) {
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ ProfileClassEditorAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    DataObject dobj = (DataObject)nodes[0].getLookup().lookup(DataObject.class);
                    if (dobj == null) {
                        return;
                    }
                    JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)dobj.getPrimaryFile());
                    if (src == null) {
                        return;
                    }
                    int currentOffsetInEditor = EditorSupport.getCurrentOffset();
                    if (currentOffsetInEditor == -1) {
                        return;
                    }
                    Lookup.Provider project = null;
                    SourceClassInfo resolvedClass = src.resolveClassAtPosition(currentOffsetInEditor, true);
                    if (resolvedClass == null) {
                        SourceMethodInfo resolvedMethod = src.resolveMethodAtPosition(currentOffsetInEditor);
                        if (resolvedMethod != null) {
                            project = ProjectUtilities.getProject((FileObject)dobj.getPrimaryFile());
                            resolvedClass = ProfilerTypeUtils.resolveClass((String)resolvedMethod.getClassName(), (Lookup.Provider)project);
                        }
                        if (resolvedClass == null) {
                            ProfilerDialogs.displayWarning((String)Bundle.ProfileClassEditorAction_NoClassFoundAtPosition());
                            return;
                        }
                    }
                    if (project == null) {
                        project = ProjectUtilities.getProject((FileObject)dobj.getPrimaryFile());
                    }
                    ProfilerSession.findAndConfigure((Lookup)Lookups.fixed((Object[])new Object[]{resolvedClass}), (Lookup.Provider)project, (String)this.this$0.getName());
                }
                catch (Exception ex) {
                    ProfilerDialogs.displayWarning((String)Bundle.ProfileClassEditorAction_ProblemProfilingClass());
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

