/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.project.ProjectContainerProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public class ProjectContainerProviderImpl
implements ProjectContainerProvider {
    private final Project project;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final PropertyChangeListener propertyChange;

    public ProjectContainerProviderImpl(Project proj) {
        this.project = proj;
        this.propertyChange = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    ProjectContainerProviderImpl.this.cs.fireChange();
                }
            }
        };
    }

    public ProjectContainerProvider.Result getContainedProjects() {
        HashSet<Project> projects = new HashSet<Project>();
        File basedir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        try {
            this.addProjectModules(basedir, projects, ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getModules());
        }
        catch (InterruptedException x) {
            return new ProjectContainerProvider.Result(Collections.emptySet(), false);
        }
        projects.remove(this.project);
        return new ProjectContainerProvider.Result(projects, false);
    }

    private boolean isProcessed(Set<Project> resultset, FileObject projectDir) {
        for (Project p : resultset) {
            if (!p.getProjectDirectory().equals(projectDir)) continue;
            return true;
        }
        return false;
    }

    private void addProjectModules(File basedir, Set<Project> resultset, List<String> modules) throws InterruptedException {
        if (modules == null) {
            return;
        }
        for (String path : modules) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (path.trim().length() == 0) continue;
            File sub = new File(basedir, path);
            File projectFile = FileUtil.normalizeFile((File)sub);
            if (!projectFile.equals(basedir) && projectFile.exists()) {
                FileObject projectDir = FileUtil.toFileObject((File)projectFile);
                if (projectDir != null && projectDir.isFolder() && !this.isProcessed(resultset, projectDir)) {
                    Project proj = this.processOneSubproject(projectDir);
                    NbMavenProjectImpl mv = proj != null ? (NbMavenProjectImpl)proj.getLookup().lookup(NbMavenProjectImpl.class) : null;
                    if (mv == null) continue;
                    resultset.add(proj);
                    continue;
                }
                ErrorManager.getDefault().log("fileobject not found=" + String.valueOf(sub));
                continue;
            }
            ErrorManager.getDefault().log("project file not found=" + String.valueOf(sub));
        }
    }

    private Project processOneSubproject(FileObject projectDir) {
        try {
            return ProjectManager.getDefault().findProject(projectDir);
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
            return null;
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (!this.cs.hasListeners()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.propertyChange);
        }
        this.cs.addChangeListener(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
        if (!this.cs.hasListeners()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).removePropertyChangeListener(this.propertyChange);
        }
    }
}

