/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.memorylint.Rule;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class AnalysisControllerUI
extends JPanel {
    private AbstractButton presenter;
    private AnalysisController analysisController;
    private HTMLTextArea resultsArea;
    private HTMLTextArea settingsArea;
    private JButton performButton;
    private JPanel resultsContainer;
    private JPanel rulesContainer;
    private JSplitPane contentsSplit;

    public AnalysisControllerUI(AnalysisController analysisController) {
        this.analysisController = analysisController;
        this.initComponents();
        this.initRules();
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    public void displayNewRules() {
        this.initRules();
    }

    public void setResult(final String result) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ AnalysisControllerUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.resultsContainer.removeAll();
                HTMLTextArea resultDisplayer = new HTMLTextArea(result){

                    protected void showURL(URL url) {
                        this$0.analysisController.showURL(url);
                    }
                };
                try {
                    resultDisplayer.setCaretPosition(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.this$0.resultsContainer.add((Component)resultDisplayer, "Center");
                this.this$0.resultsContainer.invalidate();
                this.this$0.revalidate();
                this.this$0.repaint();
            }
        });
    }

    private boolean[] getRulesSelection() {
        ArrayList<JCheckBox> ruleCheckboxes = new ArrayList<JCheckBox>();
        for (Component component : this.rulesContainer.getComponents()) {
            if (!(component instanceof JCheckBox) || !((JCheckBox)component).getActionCommand().equals("RULE_CHECKBOX")) continue;
            ruleCheckboxes.add((JCheckBox)component);
        }
        boolean[] rulesSelection = new boolean[ruleCheckboxes.size()];
        for (int i = 0; i < rulesSelection.length; ++i) {
            rulesSelection[i] = ((JCheckBox)ruleCheckboxes.get(i)).isSelected();
        }
        return rulesSelection;
    }

    private void cancelAnalysis() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AnalysisControllerUI.this.resultsContainer.removeAll();
                AnalysisControllerUI.this.resultsContainer.invalidate();
                AnalysisControllerUI.this.revalidate();
                AnalysisControllerUI.this.repaint();
                AnalysisControllerUI.this.performButton.setEnabled(true);
            }
        });
        this.analysisController.cancelAnalysis();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JSeparator separator = new JSeparator(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, 1);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 1);
            }
        };
        separator.setBackground(this.getBackground());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)separator, constraints);
        this.settingsArea = new HTMLTextArea();
        String rulesRes = Icons.getResource((String)"HeapWalkerIcons.Rules");
        this.settingsArea.setText("<b><img border='0' align='bottom' src='nbresloc:/" + rulesRes + "'>&nbsp;&nbsp;" + Bundle.AnalysisControllerUI_RulesToApplyString() + "</b><br><hr>&nbsp;&nbsp;&nbsp;&nbsp;Searching for rules...");
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.settingsArea, constraints);
        this.performButton = new JButton(Bundle.AnalysisControllerUI_PerformButtonText());
        this.performButton.setEnabled(false);
        this.performButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisControllerUI.this.performAnalysis();
            }
        });
        this.rulesContainer = new JPanel(new GridBagLayout());
        this.rulesContainer.setOpaque(true);
        JScrollPane rulesContainerScrollPane = new JScrollPane(this.rulesContainer, 20, 30){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                int height = Math.min(pref.height, 200);
                return new Dimension(pref.width, height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        rulesContainerScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        rulesContainerScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        rulesContainerScrollPane.setBorder(BorderFactory.createEmptyBorder());
        rulesContainerScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        rulesContainerScrollPane.setBackground(this.settingsArea.getBackground());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 15, 5, 5);
        this.add((Component)rulesContainerScrollPane, constraints);
        this.resultsArea = new HTMLTextArea();
        String propertiesRes = Icons.getResource((String)"HeapWalkerIcons.Properties");
        this.resultsArea.setText("<b><img border='0' align='bottom' src='nbresloc:/" + propertiesRes + "'>&nbsp;&nbsp;" + Bundle.AnalysisControllerUI_AnalysisResultsText() + "</b><br><hr>");
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.resultsArea, constraints);
        this.resultsContainer = new JPanel(new BorderLayout());
        this.resultsContainer.setOpaque(true);
        JScrollPane resultsContainerScrollPane = new JScrollPane(this.resultsContainer, 20, 30){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                int height = Math.min(pref.height, 160);
                return new Dimension(pref.width, height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        resultsContainerScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        resultsContainerScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        resultsContainerScrollPane.setBorder(BorderFactory.createEmptyBorder());
        resultsContainerScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        resultsContainerScrollPane.setBackground(this.settingsArea.getBackground());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 15, 5, 8);
        this.add((Component)resultsContainerScrollPane, constraints);
        this.setBackground(this.settingsArea.getBackground());
        this.rulesContainer.setBackground(this.settingsArea.getBackground());
        this.resultsContainer.setBackground(this.settingsArea.getBackground());
    }

    private void initRules() {
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                final List<Rule> rules = AnalysisControllerUI.this.analysisController.getRules();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = this.this$1.AnalysisControllerUI.this.getTreeLock();
                        synchronized (object) {
                            GridBagConstraints constraints;
                            this.this$1.AnalysisControllerUI.this.rulesContainer.removeAll();
                            for (int i = 0; i < rules.size(); ++i) {
                                final Rule rule = (Rule)rules.get(i);
                                String ruleName = rule.getDisplayName();
                                String ruleDescription = rule.getDescription();
                                JComponent ruleCustomizer = rule.getCustomizer();
                                final String htmlDescription = rule.getHTMLDescription();
                                JCheckBox checkBox = new JCheckBox(ruleName);
                                checkBox.setActionCommand("RULE_CHECKBOX");
                                checkBox.setOpaque(false);
                                checkBox.setToolTipText(ruleDescription);
                                constraints = new GridBagConstraints();
                                constraints.gridx = 0;
                                constraints.gridy = i;
                                constraints.gridwidth = ruleCustomizer == null && htmlDescription == null ? 0 : 1;
                                constraints.fill = 0;
                                constraints.anchor = 17;
                                constraints.insets = new Insets(0, 0, 0, 0);
                                this.this$1.AnalysisControllerUI.this.rulesContainer.add((Component)checkBox, constraints);
                                checkBox.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        this$1.AnalysisControllerUI.this.updatePerformButton();
                                    }
                                });
                                if (htmlDescription != null) {
                                    HTMLLabel description = new HTMLLabel(this, "<a href='#info'>" + Bundle.AnalysisControllerUI_InfoString() + "</a>"){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                            super(text);
                                        }

                                        protected void showURL(URL url) {
                                            DescriptionDisplayer.showDescription(rule, htmlDescription);
                                        }
                                    };
                                    description.setOpaque(false);
                                    constraints = new GridBagConstraints();
                                    constraints.gridx = 1;
                                    constraints.gridy = i;
                                    constraints.gridwidth = ruleCustomizer == null ? 0 : 1;
                                    constraints.fill = 0;
                                    constraints.anchor = 17;
                                    constraints.insets = new Insets(0, 2, 0, 0);
                                    this.this$1.AnalysisControllerUI.this.rulesContainer.add((Component)description, constraints);
                                }
                                if (ruleCustomizer == null) continue;
                                ruleCustomizer.setOpaque(false);
                                constraints = new GridBagConstraints();
                                constraints.gridx = 2;
                                constraints.gridy = i;
                                constraints.gridwidth = 0;
                                constraints.fill = 0;
                                constraints.anchor = 17;
                                constraints.insets = new Insets(0, 8, 0, 5);
                                this.this$1.AnalysisControllerUI.this.rulesContainer.add((Component)ruleCustomizer, constraints);
                            }
                            JPanel fillerPanel = new JPanel(new GridBagLayout());
                            fillerPanel.setOpaque(false);
                            constraints = new GridBagConstraints();
                            constraints.gridx = 0;
                            constraints.gridy = rules.size();
                            constraints.gridwidth = 0;
                            constraints.weightx = 1.0;
                            constraints.fill = 2;
                            constraints.anchor = 17;
                            constraints.insets = new Insets(0, 0, 0, 0);
                            this.this$1.AnalysisControllerUI.this.rulesContainer.add((Component)fillerPanel, constraints);
                            constraints = new GridBagConstraints();
                            constraints.gridx = 1;
                            constraints.gridy = 3;
                            constraints.gridwidth = 1;
                            constraints.fill = 0;
                            constraints.anchor = 13;
                            constraints.insets = new Insets(3, 0, 0, 8);
                            this.this$1.AnalysisControllerUI.this.add((Component)this.this$1.AnalysisControllerUI.this.performButton, constraints);
                            String rulesRes = Icons.getResource((String)"HeapWalkerIcons.Rules");
                            this.this$1.AnalysisControllerUI.this.settingsArea.setText("<b><img border='0' align='bottom' src='nbresloc:/" + rulesRes + "'>&nbsp;&nbsp;" + Bundle.AnalysisControllerUI_RulesToApplyString() + "</b><br><hr>");
                            this.this$1.AnalysisControllerUI.this.updatePerformButton();
                        }
                    }
                });
            }
        });
    }

    private void performAnalysis() {
        this.performButton.setEnabled(false);
        BoundedRangeModel progressModel = this.analysisController.performAnalysis(this.getRulesSelection());
        this.resultsContainer.removeAll();
        JPanel progressContainer = new JPanel(new GridBagLayout());
        progressContainer.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 5);
        progressContainer.add((Component)new JLabel(Bundle.AnalysisControllerUI_ProcessingRulesMsg() + "  "), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 8);
        progressContainer.add((Component)new JProgressBar(progressModel), constraints);
        JButton cancelAnalysis = new JButton(Bundle.AnalysisControllerUI_CancelButtonText());
        cancelAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisControllerUI.this.cancelAnalysis();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(0, 0, 0, 8);
        progressContainer.add((Component)cancelAnalysis, constraints);
        this.resultsContainer.add((Component)progressContainer, "North");
        this.resultsContainer.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void updatePerformButton() {
        if (this.analysisController.isAnalysisRunning()) {
            this.performButton.setEnabled(false);
        } else {
            boolean[] rulesSelection = this.getRulesSelection();
            if (rulesSelection.length > 0) {
                for (boolean checked : rulesSelection) {
                    if (!checked) continue;
                    this.performButton.setEnabled(true);
                    return;
                }
            }
            this.performButton.setEnabled(false);
        }
    }

    private static class Presenter
    extends JToggleButton {
        private static Icon ICON_INFO = Icons.getIcon((String)"HeapWalkerIcons.MemoryLint");

        public Presenter() {
            this.setText(Bundle.AnalysisControllerUI_ControllerName());
            this.setToolTipText(Bundle.AnalysisControllerUI_ControllerDescr());
            this.setIcon(ICON_INFO);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width += 4;
            return d;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    private static class DescriptionDisplayer
    extends JPanel {
        private DescriptionDisplayer(URL ruleBase, String htmlDescription) {
            this.initComponents(ruleBase, htmlDescription);
        }

        public static void showDescription(Rule rule, String htmlDescription) {
            Class<?> ruleClass = rule.getClass();
            URL ruleBase = ruleClass.getResource(ruleClass.getSimpleName() + ".class");
            DialogDescriptor dd = new DialogDescriptor((Object)new DescriptionDisplayer(ruleBase, htmlDescription), rule.getDisplayName(), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.pack();
            d.setVisible(true);
        }

        private void initComponents(URL ruleBase, String htmlDescription) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            HTMLTextArea descriptionArea = new HTMLTextArea();
            HTMLDocument hdoc = (HTMLDocument)descriptionArea.getDocument();
            descriptionArea.setText(htmlDescription);
            descriptionArea.setCaretPosition(0);
            hdoc.setBase(ruleBase);
            JScrollPane descriptionAreaScrollPane = new JScrollPane((Component)descriptionArea, 20, 30);
            descriptionAreaScrollPane.setPreferredSize(new Dimension(375, 220));
            this.add((Component)descriptionAreaScrollPane, "Center");
        }
    }
}

