/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.diff.DiffViewModeSwitcher;
import org.netbeans.modules.versioning.ui.history.DiffPanel;
import org.netbeans.modules.versioning.ui.history.History;
import org.netbeans.modules.versioning.ui.history.HistoryComponent;
import org.netbeans.modules.versioning.ui.history.HistoryEntry;
import org.netbeans.modules.versioning.ui.history.RevisionNode;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class HistoryDiffView
implements PropertyChangeListener {
    private final HistoryComponent tc;
    private DiffPanel panel;
    private Component diffComponent;
    private DiffController diffView;
    private DiffTask diffTask;
    private final Object VIEW_LOCK = new Object();
    private DiffViewModeSwitcher diffViewModeSwitcher;
    private boolean onSelectionLastDifference = false;
    private Map<String, DiffController> views = new ConcurrentHashMap<String, DiffController>();

    public HistoryDiffView(HistoryComponent tc) {
        this.tc = tc;
        this.panel = new DiffPanel();
        this.showNoContent(NbBundle.getMessage(HistoryDiffView.class, (String)"MSG_DiffPanel_NoVersion"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            this.tc.disableNavigationButtons();
            this.refresh((Node[])evt.getNewValue());
        } else if ("(void) differencesChanged".equals(evt.getPropertyName())) {
            Object object = this.VIEW_LOCK;
            synchronized (object) {
                if (this.diffView != null) {
                    this.tc.refreshNavigationButtons(this.diffView.getDifferenceIndex(), this.diffView.getDifferenceCount());
                }
            }
        }
    }

    JPanel getPanel() {
        return this.panel;
    }

    private void refresh(Node[] newSelection) {
        if (newSelection != null) {
            HistoryEntry entry1;
            if (newSelection.length == 1) {
                entry1 = (HistoryEntry)newSelection[0].getLookup().lookup(HistoryEntry.class);
                if (entry1 != null) {
                    VCSFileProxy file1 = this.getFile(newSelection[0], entry1);
                    HistoryComponent.CompareMode mode = this.tc.getMode();
                    switch (mode) {
                        case TOCURRENT: {
                            this.refreshCurrentDiffPanel(entry1, file1);
                            return;
                        }
                        case TOPARENT: {
                            this.refreshRevisionDiffPanel(null, entry1, null, file1);
                            return;
                        }
                    }
                    throw new IllegalStateException("Wrong mode selected: " + (Object)((Object)mode));
                }
            } else if (newSelection.length == 2) {
                entry1 = (HistoryEntry)newSelection[0].getLookup().lookup(HistoryEntry.class);
                VCSFileProxy file1 = null;
                if (entry1 != null) {
                    file1 = this.getFile(newSelection[0], entry1);
                }
                VCSFileProxy file2 = null;
                HistoryEntry entry2 = (HistoryEntry)newSelection[1].getLookup().lookup(HistoryEntry.class);
                if (entry2 != null) {
                    file2 = file1 = this.getFile(newSelection[1], entry2);
                }
                if (entry1 != null && entry2 != null && file1 != null && file2 != null) {
                    if (entry1.getDateTime().getTime() > entry2.getDateTime().getTime()) {
                        this.refreshRevisionDiffPanel(entry1, entry2, file1, file2);
                    } else {
                        this.refreshRevisionDiffPanel(entry2, entry1, file2, file1);
                    }
                    return;
                }
            }
        }
        String msgKey = newSelection == null || newSelection.length == 0 ? "MSG_DiffPanel_NoVersion" : "MSG_DiffPanel_IllegalSelection";
        this.showNoContent(NbBundle.getMessage(HistoryDiffView.class, (String)msgKey));
    }

    private void refreshRevisionDiffPanel(HistoryEntry entry1, HistoryEntry entry2, VCSFileProxy file1, VCSFileProxy file2) {
        this.onSelectionLastDifference = false;
        this.scheduleTask(new RevisionDiffPrepareTask(entry1, entry2, file1, file2, this.onSelectionLastDifference));
    }

    private void refreshCurrentDiffPanel(HistoryEntry entry, VCSFileProxy file) {
        this.onSelectionLastDifference = false;
        this.scheduleTask(new CurrentDiffPrepareTask(entry, file, this.onSelectionLastDifference));
    }

    private void scheduleTask(DiffTask newTask) {
        if (this.diffTask != null) {
            this.diffTask.cancel();
        }
        this.diffTask = newTask;
        this.diffTask.schedule();
    }

    private VCSFileProxy getFile(Node node, HistoryEntry entry) {
        Collection proxies = node.getLookup().lookupAll(VCSFileProxy.class);
        if (proxies != null && proxies.size() == 1) {
            return (VCSFileProxy)proxies.iterator().next();
        }
        VCSFileProxy[] files = entry.getFiles();
        if (files.length == 2) {
            if (files[0].getName().endsWith(".java") && files[1].getName().endsWith(".form")) {
                return files[0];
            }
            if (files[1].getName().endsWith(".java") && files[0].getName().endsWith(".form")) {
                return files[1];
            }
        }
        return files[0];
    }

    void onSelectionLastDifference() {
        this.onSelectionLastDifference = true;
    }

    void componentClosed() {
        DiffViewModeSwitcher.release((Object)this);
        this.diffViewModeSwitcher = null;
    }

    private DiffController getView(HistoryEntry entry, VCSFileProxy file) {
        assert (entry != null);
        if (entry == null) {
            return null;
        }
        return this.views.get(this.getKey(entry, file));
    }

    private DiffController getView(HistoryEntry entry1, VCSFileProxy file1, HistoryEntry entry2) {
        assert (entry1 != null && entry2 != null);
        if (entry1 == null && entry2 == null) {
            return null;
        }
        return this.views.get(this.getKey(entry1, file1, entry2));
    }

    private void putView(DiffController dv, HistoryEntry entry1, VCSFileProxy file1, HistoryEntry entry2) {
        this.views.put(this.getKey(entry1, file1, entry2), dv);
    }

    private void putView(DiffController dv, HistoryEntry entry, VCSFileProxy file) {
        this.views.put(this.getKey(entry, file), dv);
    }

    private String getKey(HistoryEntry entry1, VCSFileProxy file1, HistoryEntry entry2) {
        return this.getKey(entry1, file1) + "_" + entry2.getRevision() + "_" + entry2.getDateTime().getTime();
    }

    private String getKey(HistoryEntry entry, VCSFileProxy file) {
        return entry.getRevision() + "_" + entry.getDateTime().getTime() + "_" + file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDiffView(final DiffController dv, final boolean selectLast) {
        final int diffCount = dv.getDifferenceCount();
        final int diffIdx = dv.getDifferenceIndex();
        Object object = this.VIEW_LOCK;
        synchronized (object) {
            this.diffView = dv;
        }
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ HistoryDiffView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                History.LOG.finer("invoked set diff view");
                this.this$0.getDiffViewModeSwitcher().setupMode(dv);
                JComponent c = dv.getJComponent();
                this.this$0.setDiffComponent(c);
                this.this$0.tc.setDiffView(c);
                if (dv.getDifferenceCount() > 0) {
                    this.this$0.setCurrentDifference(selectLast ? diffCount - 1 : 0);
                } else {
                    this.this$0.tc.refreshNavigationButtons(diffIdx, diffCount);
                }
                this.this$0.panel.revalidate();
                this.this$0.panel.repaint();
            }
        });
    }

    private DiffViewModeSwitcher getDiffViewModeSwitcher() {
        if (this.diffViewModeSwitcher == null) {
            this.diffViewModeSwitcher = DiffViewModeSwitcher.get((Object)this);
        }
        return this.diffViewModeSwitcher;
    }

    private String getTitle(HistoryEntry entry, VCSFileProxy file) {
        String title1 = file.exists() ? (entry.isLocalHistory() ? "<html>" + file.getName() + " (<b>" + RevisionNode.getFormatedDate(entry) + "</b>)</html>" : "<html>" + file.getName() + " (<b>" + entry.getRevisionShort() + "</b>)</html>") : NbBundle.getMessage(HistoryDiffView.class, (String)"LBL_Diff_FileDeleted");
        return title1;
    }

    private DiffController prepareDiffView(FileObject file1, FileObject file2, boolean file1Exists, boolean file2Exists, String title1, String title2, boolean editable, final boolean selectLast) {
        DiffController dv;
        History.LOG.log(Level.FINE, "preparing diff view for: {0} - {1} and {2} - {3}", new Object[]{title1, file1, title2, file2});
        LHStreamSource ss1 = file1Exists ? new LHStreamSource(file1, title1, this.getMimeType(file2), editable) : StreamSource.createSource((String)"currentfile", (String)title1, (String)this.getMimeType(file1), (Reader)new StringReader(""));
        LHStreamSource ss2 = file2Exists ? new LHStreamSource(file2, title2, this.getMimeType(file2), editable) : StreamSource.createSource((String)"currentfile", (String)title2, (String)this.getMimeType(file2), (Reader)new StringReader(""));
        try {
            dv = DiffController.createEnhanced((StreamSource)ss1, (StreamSource)ss2);
        }
        catch (IOException ioe) {
            History.LOG.log(Level.SEVERE, null, ioe);
            return null;
        }
        dv.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ HistoryDiffView this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("(void) differencesChanged".equals(evt.getPropertyName())) {
                    dv.removePropertyChangeListener((PropertyChangeListener)this);
                    int diffCount = dv.getDifferenceCount();
                    Object object = this.this$0.VIEW_LOCK;
                    synchronized (object) {
                        if (dv == this.this$0.diffView && diffCount > 0) {
                            this.this$0.setCurrentDifference(selectLast ? diffCount - 1 : 0);
                        }
                    }
                }
            }
        });
        dv.addPropertyChangeListener((PropertyChangeListener)this);
        return dv;
    }

    private String getMimeType(FileObject file) {
        FileObject fo = file;
        if (fo != null) {
            return fo.getMIMEType();
        }
        return "content/unknown";
    }

    private void showNoContent(String s) {
        this.setDiffComponent((Component)new NoContentPanel(s));
    }

    private void setDiffComponent(Component component) {
        if (this.diffComponent != null) {
            this.panel.diffPanel.remove(this.diffComponent);
            History.LOG.log(Level.FINEST, "replaced current diff component {0}", this.diffComponent);
        }
        this.panel.diffPanel.add(component, "Center");
        this.diffComponent = component;
        History.LOG.log(Level.FINEST, "added diff component {0}", this.diffComponent);
        this.panel.diffPanel.revalidate();
        this.panel.diffPanel.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNextButton() {
        Object object = this.VIEW_LOCK;
        synchronized (object) {
            if (this.diffView == null) {
                return;
            }
            int nextDiffernce = this.diffView.getDifferenceIndex() + 1;
            if (nextDiffernce < this.diffView.getDifferenceCount()) {
                this.setCurrentDifference(nextDiffernce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPrevButton() {
        Object object = this.VIEW_LOCK;
        synchronized (object) {
            if (this.diffView == null) {
                return;
            }
            int prevDiffernce = this.diffView.getDifferenceIndex() - 1;
            if (prevDiffernce > -1) {
                this.setCurrentDifference(prevDiffernce);
            }
        }
    }

    void modeChanged() {
        this.refresh(this.tc.getSelectedNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentDifference(int idx) {
        Object object = this.VIEW_LOCK;
        synchronized (object) {
            if (this.diffView == null) {
                return;
            }
            this.diffView.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, idx);
            this.tc.refreshNavigationButtons(this.diffView.getDifferenceIndex(), this.diffView.getDifferenceCount());
        }
    }

    private class RevisionDiffPrepareTask
    extends DiffTask {
        private HistoryEntry entry1;
        private final HistoryEntry entry2;
        private VCSFileProxy file1;
        private final VCSFileProxy file2;
        private final boolean selectLast;

        public RevisionDiffPrepareTask(HistoryEntry entry1, HistoryEntry entry2, VCSFileProxy file1, VCSFileProxy file2, boolean selectLast) {
            this.entry1 = entry1;
            this.entry2 = entry2;
            this.file1 = file1;
            this.file2 = file2;
            this.selectLast = selectLast;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileObject revisionFo2;
            FileObject revisionFo1;
            History.LOG.log(Level.FINE, "preparing previous diff for: {0} - {1} and {2} - {3}", new Object[]{this.entry1, this.file1, this.entry2, this.file2});
            this.startPrepareProgress();
            try {
                if (this.entry1 == null && this.file1 == null) {
                    this.entry1 = this.entry2.getParent(this.file2);
                    if (this.entry1 == null) {
                        this.entry1 = HistoryDiffView.this.tc.getParentEntry(this.entry2);
                        if (this.isCancelled()) {
                            return;
                        }
                    }
                    this.file1 = this.file2;
                    if (this.entry1 == null) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HistoryDiffView.this.showNoContent(NbBundle.getMessage(HistoryDiffView.class, (String)"MSG_DiffPanel_NoVersionToCompare"));
                            }
                        });
                        return;
                    }
                }
                DiffController dv = HistoryDiffView.this.getView(this.entry2, this.file2, this.entry1);
                if (this.isCancelled()) {
                    return;
                }
                if (dv != null) {
                    History.LOG.log(Level.FINE, "setting cached diff view for: {0} - {1} and {2} - {3}", new Object[]{this.entry1, this.file1, this.entry2, this.file2});
                    HistoryDiffView.this.setDiffView(dv, this.selectLast);
                    return;
                }
                revisionFo1 = this.getRevisionFile(this.entry1, this.file1);
                History.LOG.log(Level.FINE, "retrieved revision file for {0} - {1}", new Object[]{this.entry1.getRevision(), this.file1});
                if (this.isCancelled()) {
                    return;
                }
                revisionFo2 = this.getRevisionFile(this.entry2, this.file2);
                History.LOG.log(Level.FINE, "retrieved revision file for {0} - {1}", new Object[]{this.entry2.getRevision(), this.file2});
                if (this.isCancelled()) {
                    return;
                }
            }
            finally {
                this.finishPrepareProgress();
            }
            String title1 = HistoryDiffView.this.getTitle(this.entry1, this.file1);
            String title2 = HistoryDiffView.this.getTitle(this.entry2, this.file2);
            DiffController dv = HistoryDiffView.this.prepareDiffView(revisionFo1, revisionFo2, true, true, title1, title2, false, this.selectLast);
            if (this.isCancelled()) {
                return;
            }
            if (dv != null) {
                History.LOG.log(Level.FINE, "setting diff view for: {0} - {1} and {2} - {3}", new Object[]{this.entry1, this.file1, this.entry2, this.file2});
                HistoryDiffView.this.setDiffView(dv, this.selectLast);
                HistoryDiffView.this.putView(dv, this.entry1, this.file1, this.entry2);
            }
        }

        private FileObject getRevisionFile(HistoryEntry entry, VCSFileProxy file) {
            File tempFolder = Utils.getTempFolder();
            File revFile = new File(tempFolder, file.getName());
            entry.getRevisionFile(file, VCSFileProxy.createFileProxy((File)revFile));
            return FileUtil.toFileObject((File)revFile);
        }
    }

    private abstract class DiffTask
    implements Runnable,
    Cancellable {
        private RequestProcessor.Task task = null;
        private boolean cancelled = false;
        private PreparingDiffHandler preparingDiffPanel;

        private DiffTask() {
        }

        void startPrepareProgress() {
            this.preparingDiffPanel = new PreparingDiffHandler();
            this.preparingDiffPanel.startPrepareProgress();
        }

        void finishPrepareProgress() {
            this.preparingDiffPanel.finishPrepareProgress();
        }

        public synchronized boolean cancel() {
            this.cancelled = true;
            if (this.preparingDiffPanel != null) {
                this.preparingDiffPanel.finishPrepareProgress();
            }
            if (this.task != null) {
                this.task.cancel();
            }
            History.LOG.finer("cancelling DiffTask");
            return true;
        }

        synchronized void schedule() {
            this.task = History.getInstance().getRequestProcessor().create((Runnable)this);
            this.task.schedule(500);
        }

        protected synchronized boolean isCancelled() {
            if (this.cancelled) {
                History.LOG.finer("DiffTask is cancelled");
            }
            return this.cancelled;
        }

        private class PreparingDiffHandler
        extends JPanel
        implements ActionListener {
            private JLabel label = new JLabel();
            private Component progressComponent;
            private ProgressHandle handle;
            private final Timer timer = new Timer(0, this);
            private final Object TIMER_LOCK = new Object();

            public PreparingDiffHandler() {
                this.label.setText(NbBundle.getMessage(HistoryDiffView.class, (String)"LBL_PreparingDiff"));
                this.setBackground(UIManager.getColor("TextArea.background"));
                this.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                this.add((Component)this.label, c);
                this.label.setEnabled(false);
                this.timer.setRepeats(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (DiffTask.this.isCancelled()) {
                    return;
                }
                Object object = this.TIMER_LOCK;
                synchronized (object) {
                    this.handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(HistoryDiffView.class, (String)"LBL_PreparingDiff"));
                    this.setProgressComponent(ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle));
                    this.handle.start();
                    this.handle.switchToIndeterminate();
                    HistoryDiffView.this.setDiffComponent(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void startPrepareProgress() {
                History.LOG.fine("starting prepare diff handler");
                Object object = this.TIMER_LOCK;
                synchronized (object) {
                    this.timer.start();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void finishPrepareProgress() {
                History.LOG.fine("finishing prepare diff handler");
                Object object = this.TIMER_LOCK;
                synchronized (object) {
                    this.timer.stop();
                    if (this.handle != null) {
                        this.handle.finish();
                    }
                }
            }

            private void setProgressComponent(Component component) {
                if (this.progressComponent != null) {
                    this.remove(this.progressComponent);
                }
                if (component != null) {
                    this.progressComponent = component;
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.insets = new Insets(0, 5, 0, 0);
                    this.add(component, gridBagConstraints);
                }
            }
        }
    }

    private class CurrentDiffPrepareTask
    extends DiffTask {
        private final HistoryEntry entry;
        private final VCSFileProxy file;
        private final boolean selectLast;

        public CurrentDiffPrepareTask(HistoryEntry entry, VCSFileProxy file, boolean selectLast) {
            this.entry = entry;
            this.file = file;
            this.selectLast = selectLast;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileObject tmpFo;
            History.LOG.log(Level.FINE, "preparing current diff for: {0} - {1}", new Object[]{this.entry, this.file});
            DiffController dv = HistoryDiffView.this.getView(this.entry, this.file);
            if (this.isCancelled()) {
                return;
            }
            if (dv != null) {
                History.LOG.log(Level.FINE, "setting cached diff view for {0} - {1}", new Object[]{this.entry.getRevision(), this.file});
                HistoryDiffView.this.setDiffView(dv, this.selectLast);
                return;
            }
            if (this.isCancelled()) {
                return;
            }
            this.startPrepareProgress();
            try {
                File tempFolder = Utils.getTempFolder();
                File tmpFile = new File(tempFolder, this.file.getName());
                this.entry.getRevisionFile(this.file, VCSFileProxy.createFileProxy((File)tmpFile));
                tmpFo = FileUtil.toFileObject((File)tmpFile);
                History.LOG.log(Level.FINE, "retrieved revision file for {0} {1}", new Object[]{this.entry.getRevision(), this.file});
                if (this.isCancelled()) {
                    return;
                }
            }
            finally {
                this.finishPrepareProgress();
            }
            String title1 = HistoryDiffView.this.getTitle(this.entry, this.file);
            String title2 = this.file.exists() ? "<html><b>" + NbBundle.getMessage(HistoryDiffView.class, (String)"LBL_Diff_CurrentFile") + "</b></html>" : NbBundle.getMessage(HistoryDiffView.class, (String)"LBL_Diff_FileDeleted");
            dv = HistoryDiffView.this.prepareDiffView(tmpFo, this.file.toFileObject(), true, this.file.exists(), title1, title2, true, this.selectLast);
            if (this.isCancelled()) {
                return;
            }
            if (dv != null) {
                History.LOG.log(Level.FINE, "setting diff view for {0} - {1}", new Object[]{this.entry.getRevision(), this.file});
                HistoryDiffView.this.setDiffView(dv, this.selectLast);
                HistoryDiffView.this.putView(dv, this.entry, this.file);
            }
        }
    }

    private class LHStreamSource
    extends StreamSource {
        private final FileObject file;
        private final String title;
        private final String mimeType;
        private final boolean editable;

        public LHStreamSource(FileObject file, String title, String mimeType, boolean editable) {
            this.file = file;
            this.title = title;
            this.mimeType = mimeType;
            this.editable = editable;
        }

        public boolean isEditable() {
            return this.editable && this.isPrimary(this.file);
        }

        private boolean isPrimary(FileObject fo) {
            if (fo != null) {
                try {
                    DataObject dao = DataObject.find((FileObject)fo);
                    return fo.equals(dao.getPrimaryFile());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return true;
        }

        public Lookup getLookup() {
            if (this.file != null && this.isPrimary(this.file)) {
                return Lookups.fixed((Object[])new Object[]{this.file});
            }
            return Lookups.fixed((Object[])new Object[0]);
        }

        public String getName() {
            return this.title;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMIMEType() {
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            if (this.file != null) {
                return new InputStreamReader(this.file.getInputStream());
            }
            return new StringReader("");
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            return null;
        }
    }
}

