/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.compiler;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.codehaus.groovy.transform.ASTTransformation;
import org.netbeans.modules.groovy.editor.api.parser.ApplyGroovyTransformation;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParser;
import org.netbeans.modules.groovy.editor.compiler.ParsingCompilerCustomizer;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

public class ApplyGroovyTransformationProcessor
extends LayerGeneratingProcessor {
    private static final Set<String> APPLY_DEFAULT = new HashSet<String>(Arrays.asList("parse"));

    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(ApplyGroovyTransformation.class.getCanonicalName());
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        if (roundEnv.processingOver()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ApplyGroovyTransformation.class)) {
            ApplyGroovyTransformation agt = element.getAnnotation(ApplyGroovyTransformation.class);
            String[] transformations = agt.value();
            Set<String> enableFor = new HashSet<String>(Arrays.asList(agt.enable()));
            Set<String> disableFor = new HashSet<String>(Arrays.asList(agt.disable()));
            if (transformations.length == 0) {
                TypeMirror astType = this.processingEnv.getElementUtils().getTypeElement(ASTTransformation.class.getName()).asType();
                if (!this.processingEnv.getTypeUtils().isAssignable(element.asType(), astType)) {
                    throw new LayerGenerationException("Element " + String.valueOf(element) + " is not subclass of " + String.valueOf(astType) + " and transformation class is not specified by the annotation.", element);
                }
                String bn = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                transformations = new String[]{bn};
                if (enableFor.isEmpty()) {
                    enableFor = APPLY_DEFAULT;
                }
            } else if (enableFor.isEmpty() && disableFor.isEmpty()) {
                disableFor = APPLY_DEFAULT;
            }
            for (String mt : agt.mimeTypes()) {
                String fnbase = "Editors/" + mt + "/Parser";
                String en = null;
                if (element instanceof TypeElement) {
                    en = ((TypeElement)element).getQualifiedName().toString();
                } else if (element instanceof PackageElement) {
                    en = ((PackageElement)element).getQualifiedName().toString();
                } else {
                    throw new LayerGenerationException("Unexpected annotated element:" + String.valueOf(element), element);
                }
                LayerBuilder.File f = null;
                if (!enableFor.isEmpty()) {
                    f = this.generateFile(f, element, fnbase, en, enableFor, "enable", transformations);
                }
                if (!disableFor.isEmpty()) {
                    f = this.generateFile(f, element, fnbase, en, disableFor, "disable", transformations);
                }
                if (f == null) continue;
                f.write();
            }
        }
        return true;
    }

    private LayerBuilder.File generateFile(LayerBuilder.File f, Element e, String fnbase, String en, Set<String> items, String att, String[] transformations) throws LayerGenerationException {
        boolean simple;
        boolean bl = simple = items.size() == 1 && items.contains("parse");
        if (f == null) {
            f = this.layer(new Element[]{e}).instanceFile(fnbase, en).stringvalue("instanceOf", ParsingCompilerCustomizer.class.getName()).methodvalue("instanceCreate", GroovyParser.class.getName(), "customizeTransformsFromLayer");
        }
        if (!simple) {
            f.stringvalue("apply", String.join((CharSequence)",", items));
        }
        f.stringvalue(att, String.join((CharSequence)",", transformations));
        return f;
    }
}

