/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.wizard;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerSupport;
import org.netbeans.modules.docker.ui.wizard.Bundle;
import org.netbeans.modules.docker.ui.wizard.Configuration;
import org.netbeans.modules.docker.ui.wizard.DockerConnectionVisual;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class DockerConnectionPanel
implements WizardDescriptor.ExtendedAsynchronousValidatingPanel<WizardDescriptor>,
ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(DockerConnectionPanel.class.getName());
    private static final Pattern REMOTE_HOST_PATTERN = Pattern.compile("^(tcp://)[^/:](:\\d+)($|/.*)");
    private static final String CONNECTION_TEST = "connection_test";
    private static final String CONNECTION_EXCEPTION_MSG = "connection_exception_msg";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Map<String, Object> values = new HashMap<String, Object>();
    private DockerConnectionVisual component;
    private WizardDescriptor wizard;

    public DockerConnectionVisual getComponent() {
        if (this.component == null) {
            this.component = new DockerConnectionVisual(this);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("docker_registering_connection");
    }

    public boolean isValid() {
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        this.wizard.putProperty("WizardPanel_infoMessage", null);
        this.wizard.putProperty("WizardPanel_warningMessage", null);
        Boolean connectioTest = (Boolean)this.wizard.getProperty(CONNECTION_TEST);
        this.wizard.putProperty(CONNECTION_TEST, null);
        String connectionExceptionMessage = (String)this.wizard.getProperty(CONNECTION_EXCEPTION_MSG);
        this.wizard.putProperty(CONNECTION_EXCEPTION_MSG, null);
        Configuration panel = this.component.getConfiguration();
        String displayName = panel.getDisplayName();
        if (displayName == null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_EmptyDisplayName());
            return false;
        }
        for (DockerInstance instance : DockerSupport.getDefault().getInstances()) {
            if (!displayName.equals(instance.getDisplayName())) continue;
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_AlreadyUsedDisplayName());
            return false;
        }
        if (panel.isSocketSelected()) {
            File socket = panel.getSocket();
            if (socket == null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_EmptySocket());
                return false;
            }
            if (!(socket.exists() && socket.canRead() && socket.canWrite())) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_InaccessibleSocket());
                return false;
            }
        } else {
            String url = panel.getUrl();
            if (url == null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_EmptyUrl());
                return false;
            }
            URL realUrl = null;
            boolean urlWrong = false;
            try {
                int port;
                realUrl = new URL(url);
                if (!"http".equals(realUrl.getProtocol()) && !"https".equals(realUrl.getProtocol())) {
                    urlWrong = true;
                }
                if ((port = realUrl.getPort()) > 65535) {
                    urlWrong = true;
                }
            }
            catch (MalformedURLException ex) {
                urlWrong = true;
            }
            if (urlWrong) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_InvalidUrl());
                return false;
            }
            String certPath = panel.getCertPath();
            if (certPath != null) {
                File certPathFile = new File(certPath);
                if (!certPathFile.isDirectory()) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_NonExistingCertificatePath());
                    return false;
                }
                if (!new File(certPathFile, "ca.pem").isFile()) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_CertificatePathMissingFile("ca.pem"));
                    return false;
                }
                if (!new File(certPathFile, "cert.pem").isFile()) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_CertificatePathMissingFile("cert.pem"));
                    return false;
                }
                if (!new File(certPathFile, "key.pem").isFile()) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_CertificatePathMissingFile("key.pem"));
                    return false;
                }
            }
            if (realUrl != null && "https".equals(realUrl.getProtocol()) && certPath == null) {
                this.wizard.putProperty("WizardPanel_warningMessage", (Object)Bundle.MSG_NoCertificatesForSecure());
            }
        }
        if (connectioTest != null) {
            if (connectioTest.booleanValue()) {
                this.wizard.putProperty("WizardPanel_infoMessage", (Object)Bundle.MSG_ConnectionPassed());
            } else if (connectionExceptionMessage != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)connectionExceptionMessage);
            } else {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_CannotConnect());
            }
            return connectioTest;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareValidation() {
        Map<String, Object> map = this.values;
        synchronized (map) {
            this.values.clear();
            Configuration panel = this.component.getConfiguration();
            this.values.put("displayName", panel.getDisplayName());
            this.values.put("socketSelected", panel.isSocketSelected());
            this.values.put("socket", panel.getSocket());
            this.values.put("url", panel.getUrl());
            this.values.put("certPath", panel.getCertPath());
        }
        this.component.setWaitingState(true);
    }

    public void finishValidation() {
        this.component.setWaitingState(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws WizardValidationException {
        try {
            DockerInstance instance;
            Map<String, Object> map = this.values;
            synchronized (map) {
                boolean socketSelected = (Boolean)this.values.get("socketSelected");
                if (socketSelected) {
                    File socket = (File)this.values.get("socket");
                    if (!(socket.exists() && socket.canRead() && socket.canWrite())) {
                        String error = Bundle.MSG_InaccessibleSocket();
                        throw new WizardValidationException((JComponent)this.component, error, error);
                    }
                    instance = DockerInstance.getInstance((String)Utilities.toURI((File)socket).toURL().toString(), null, null, null, null);
                } else {
                    File caFile = null;
                    File certFile = null;
                    File keyFile = null;
                    String strCertPath = (String)this.values.get("certPath");
                    if (strCertPath != null) {
                        File file = new File(strCertPath);
                        caFile = new File(file, "ca.pem");
                        certFile = new File(file, "cert.pem");
                        keyFile = new File(file, "key.pem");
                    }
                    instance = DockerInstance.getInstance((String)((String)this.values.get("url")), null, caFile, certFile, keyFile);
                }
            }
            DockerAction action = new DockerAction(instance);
            boolean pingResult = false;
            try {
                pingResult = action.pingWithExceptions();
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "docker connection ping failed", ex);
                throw new WizardValidationException((JComponent)this.component, Bundle.MSG_CannotConnectWithDetails(ex.getMessage()), Bundle.MSG_CannotConnectWithDetails(ex.getLocalizedMessage()));
            }
            if (!pingResult) {
                String error = Bundle.MSG_CannotConnect();
                throw new WizardValidationException((JComponent)this.component, error, error);
            }
        }
        catch (Exception ex) {
            throw new WizardValidationException((JComponent)this.component, ex.getMessage(), ex.getLocalizedMessage());
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor wiz) {
        boolean init = false;
        if (this.wizard == null) {
            init = true;
            this.wizard = wiz;
        }
        Configuration panel = this.component.getConfiguration();
        String displayName = (String)wiz.getProperty("displayName");
        if (displayName == null && init) {
            displayName = Bundle.LBL_DefaultDisplayName();
        }
        panel.setDisplayName(displayName);
        Boolean socketSelected = (Boolean)wiz.getProperty("socketSelected");
        if (socketSelected == null) {
            socketSelected = DockerSupport.getDefault().isSocketSupported();
        }
        panel.setSocketSelected(socketSelected);
        File socket = (File)wiz.getProperty("socket");
        if (socket == null && init && socketSelected.booleanValue()) {
            socket = DockerConnectionPanel.getDefaultSocket();
        }
        panel.setSocket(socket);
        String url = (String)wiz.getProperty("url");
        if (url == null && init && !socketSelected.booleanValue()) {
            url = DockerConnectionPanel.getDefaultUrl();
        }
        panel.setUrl(url);
        String certPath = (String)wiz.getProperty("certPath");
        if (certPath == null && init && !socketSelected.booleanValue()) {
            certPath = DockerConnectionPanel.getDefaultCertificatePath();
        }
        panel.setCertPath(certPath);
        this.changeSupport.fireChange();
    }

    public void storeSettings(WizardDescriptor wiz) {
        Configuration panel = this.component.getConfiguration();
        wiz.putProperty("displayName", (Object)panel.getDisplayName());
        wiz.putProperty("socketSelected", (Object)panel.isSocketSelected());
        wiz.putProperty("socket", (Object)panel.getSocket());
        wiz.putProperty("url", (Object)panel.getUrl());
        wiz.putProperty("certPath", (Object)panel.getCertPath());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    public void testConnection() {
        assert (SwingUtilities.isEventDispatchThread());
        this.prepareValidation();
        final AtomicReference ref = new AtomicReference();
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ DockerConnectionPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.validate();
                }
                catch (WizardValidationException ex) {
                    try {
                        ref.set(ex);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ AtomicReference val$ref;
                            final /* synthetic */ 1 this$1;
                            {
                                this.val$ref = atomicReference;
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                this.this$1.this$0.finishValidation();
                                Exception ex = (Exception)this.val$ref.get();
                                if (ex != null) {
                                    this.this$1.this$0.wizard.putProperty(DockerConnectionPanel.CONNECTION_EXCEPTION_MSG, (Object)ex.getLocalizedMessage());
                                    this.this$1.this$0.wizard.putProperty(DockerConnectionPanel.CONNECTION_TEST, (Object)false);
                                } else {
                                    this.this$1.this$0.wizard.putProperty(DockerConnectionPanel.CONNECTION_TEST, (Object)true);
                                }
                                this.this$1.this$0.changeSupport.fireChange();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private static File getDefaultSocket() {
        File file = new File("/var/run/docker.sock");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static String getDefaultUrl() {
        String url;
        block11: {
            url = null;
            String envUrl = System.getenv("DOCKER_HOST");
            if (envUrl != null) {
                envUrl = envUrl.trim();
                try {
                    return new URL(envUrl).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    Matcher m = REMOTE_HOST_PATTERN.matcher(envUrl);
                    if (!m.matches()) break block11;
                    boolean https = false;
                    String tlsEnv = System.getenv("DOCKER_TLS_VERIFY");
                    https = tlsEnv != null && "1".equals(tlsEnv) ? true : Integer.parseInt(m.group(2)) == 2376;
                    return (https ? "https://" : "http://") + envUrl.substring(m.group(1).length());
                }
            }
        }
        if (url == null) {
            if (Utilities.isMac() || Utilities.isWindows()) {
                if (Utilities.isWindows()) {
                    String appData = System.getenv("APPDATA");
                    if (appData != null && new File(appData, "Docker" + File.separatorChar + ".trackid").isFile()) {
                        url = "http://127.0.0.1:2375";
                    }
                } else if (Utilities.isMac()) {
                    // empty if block
                }
                if (url == null) {
                    url = new File(System.getProperty("user.home"), ".docker").isDirectory() ? "https://192.168.99.100:2376" : "https://192.168.59.103:2376";
                }
            } else {
                url = "http://127.0.0.1:2375";
            }
        }
        return url;
    }

    private static String getDefaultCertificatePath() {
        String certPath = null;
        String envPath = System.getenv("DOCKER_CERT_PATH");
        if (envPath != null && new File(envPath = envPath.trim()).isDirectory()) {
            return envPath;
        }
        if (Utilities.isMac() || Utilities.isWindows()) {
            File folder = new File(System.getProperty("user.home"), ".docker" + File.separator + "machine" + File.separator + "machines" + File.separator + "default");
            if (!folder.isDirectory()) {
                folder = new File(System.getProperty("user.home"), ".boot2docker" + File.separator + "certs" + File.separator + "boot2docker-vm");
            }
            if (folder.isDirectory()) {
                certPath = folder.getAbsolutePath();
            }
        }
        return certPath;
    }
}

