/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.phpmodule;

import java.util.Collection;
import java.util.Comparator;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public interface ImportantFilesImplementation {
    public Collection<FileInfo> getFiles();

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public static final class FileInfo {
        public static final Comparator<FileInfo> COMPARATOR = new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo o1, FileInfo o2) {
                String name2;
                String name1 = o1.getDisplayName();
                if (name1 == null) {
                    name1 = o1.getFile().getNameExt();
                }
                if ((name2 = o2.getDisplayName()) == null) {
                    name2 = o2.getFile().getNameExt();
                }
                return name1.compareToIgnoreCase(name2);
            }
        };
        private final FileObject file;
        private final String displayName;
        private final String description;

        public FileInfo(FileObject file) {
            this(file, null, null);
        }

        public FileInfo(FileObject file, @NullAllowed String displayName, @NullAllowed String description) {
            Parameters.notNull((CharSequence)"file", (Object)file);
            if (file.isFolder()) {
                throw new IllegalArgumentException("File cannot be a directory");
            }
            this.file = file;
            this.displayName = displayName;
            this.description = description;
        }

        public FileObject getFile() {
            return this.file;
        }

        @CheckForNull
        public String getDisplayName() {
            return this.displayName;
        }

        @CheckForNull
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "FileInfo{file=" + String.valueOf(this.file) + ", displayName=" + this.displayName + ", description=" + this.description + "}";
        }
    }
}

