/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.support.ForwardingLibraryImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.Parameters;

public class ProxyLibraryImplementation
extends ForwardingLibraryImplementation {
    private final LibrariesModel model;
    private Map<String, List<URL>> newContents;
    private String newName;
    private String newDisplayName;
    private String newDescription;
    private Map<String, List<URI>> newURIContents;

    private ProxyLibraryImplementation(@NonNull LibraryImplementation original, @NonNull LibrariesModel model) {
        super(original);
        Parameters.notNull((CharSequence)"model", (Object)model);
        this.model = model;
    }

    public static ProxyLibraryImplementation createProxy(LibraryImplementation original, LibrariesModel model) {
        return new ProxyLibraryImplementation(original, model);
    }

    protected LibrariesModel getModel() {
        return this.model;
    }

    public synchronized List<URL> getContent(String volumeType) throws IllegalArgumentException {
        List<URL> result = null;
        if (this.newContents == null || (result = this.newContents.get(volumeType)) == null) {
            return super.getContent(volumeType);
        }
        return result;
    }

    public synchronized String getDescription() {
        if (this.newDescription != null) {
            return this.newDescription;
        }
        return super.getDescription();
    }

    public synchronized String getName() {
        if (this.newName != null) {
            return this.newName;
        }
        return super.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName() {
        if (!LibrariesSupport.supportsDisplayName((LibraryImplementation)this.getDelegate())) {
            throw new IllegalStateException("Delegate does not support displayName");
        }
        ProxyLibraryImplementation proxyLibraryImplementation = this;
        synchronized (proxyLibraryImplementation) {
            return this.newDisplayName != null ? this.newDisplayName : super.getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(String volumeType, List<URL> path) throws IllegalArgumentException {
        ProxyLibraryImplementation proxyLibraryImplementation = this;
        synchronized (proxyLibraryImplementation) {
            if (this.newContents == null) {
                this.newContents = new HashMap<String, List<URL>>();
            }
            this.newContents.put(volumeType, path);
            this.model.modifyLibrary(this);
        }
        this.firePropertyChange("content", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String text) {
        String oldDescription;
        ProxyLibraryImplementation proxyLibraryImplementation = this;
        synchronized (proxyLibraryImplementation) {
            oldDescription = this.getDescription();
            this.newDescription = text;
            this.model.modifyLibrary(this);
        }
        this.firePropertyChange("description", oldDescription, this.newDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setName(String name) {
        String oldName;
        ProxyLibraryImplementation proxyLibraryImplementation = this;
        synchronized (proxyLibraryImplementation) {
            oldName = this.getName();
            this.newName = name;
            this.model.modifyLibrary(this);
        }
        this.firePropertyChange("name", oldName, this.newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayName(@NullAllowed String displayName) {
        String oldName;
        ProxyLibraryImplementation proxyLibraryImplementation = this;
        synchronized (proxyLibraryImplementation) {
            oldName = this.getDisplayName();
            this.newDisplayName = displayName;
            this.model.modifyLibrary(this);
        }
        this.firePropertyChange("displayName", oldName, displayName);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProxyLibraryImplementation) {
            return this.getDelegate().equals((Object)((ProxyLibraryImplementation)((Object)obj)).getDelegate());
        }
        return false;
    }

    public String toString() {
        return "Proxy[" + this.getDelegate() + "]";
    }

    public synchronized List<URI> getURIContent(String volumeType) throws IllegalArgumentException {
        List<URI> result = null;
        if (this.newURIContents == null || (result = this.newURIContents.get(volumeType)) == null) {
            return super.getURIContent(volumeType);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURIContent(String volumeType, List<URI> path) throws IllegalArgumentException {
        ProxyLibraryImplementation proxyLibraryImplementation = this;
        synchronized (proxyLibraryImplementation) {
            if (this.newURIContents == null) {
                this.newURIContents = new HashMap<String, List<URI>>();
            }
            this.newURIContents.put(volumeType, path);
            this.getModel().modifyLibrary(this);
        }
        this.firePropertyChange("content", null, null);
    }

    @CheckForNull
    synchronized Map<String, List<URI>> getNewURIContents() {
        return this.newURIContents == null ? null : Collections.unmodifiableMap(this.newURIContents);
    }

    @CheckForNull
    synchronized Map<String, List<URL>> getNewContents() {
        return this.newContents == null ? null : Collections.unmodifiableMap(this.newContents);
    }
}

