/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.fileupload.CommonsFileUploadDecoder;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.component.fileupload.NativeFileUploadDecoder;
import org.primefaces.config.ConfigContainer;
import org.primefaces.context.RequestContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class FileUploadRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        FileUpload fileUpload = (FileUpload)component;
        if (!fileUpload.isDisabled()) {
            ConfigContainer cc = RequestContext.getCurrentInstance().getApplicationContext().getConfig();
            String uploader = cc.getUploader();
            boolean isAtLeastJSF22 = cc.isAtLeastJSF22();
            if (uploader.equals("auto")) {
                if (isAtLeastJSF22) {
                    NativeFileUploadDecoder.decode(context, fileUpload);
                } else {
                    CommonsFileUploadDecoder.decode(context, fileUpload);
                }
            } else if (uploader.equals("native")) {
                if (!isAtLeastJSF22) {
                    throw new FacesException("native uploader requires at least a JSF 2.2 runtime");
                }
                NativeFileUploadDecoder.decode(context, fileUpload);
            } else if (uploader.equals("commons")) {
                CommonsFileUploadDecoder.decode(context, fileUpload);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        FileUpload fileUpload = (FileUpload)component;
        this.encodeMarkup(context, fileUpload);
        if (fileUpload.getMode().equals("advanced")) {
            this.encodeScript(context, fileUpload);
        }
    }

    protected void encodeScript(FacesContext context, FileUpload fileUpload) throws IOException {
        String clientId = fileUpload.getClientId(context);
        String update = fileUpload.getUpdate();
        String process = fileUpload.getProcess();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("FileUpload", fileUpload.resolveWidgetVar(), clientId, "fileupload");
        wb.attr("auto", fileUpload.isAuto(), false).attr("dnd", fileUpload.isDragDropSupport(), true).attr("update", SearchExpressionFacade.resolveComponentsForClient(context, (UIComponent)fileUpload, update), null).attr("process", SearchExpressionFacade.resolveComponentsForClient(context, (UIComponent)fileUpload, process), null).attr("maxFileSize", fileUpload.getSizeLimit().longValue(), 9.223372036854776E18).attr("fileLimit", fileUpload.getFileLimit(), Integer.MAX_VALUE).attr("invalidFileMessage", fileUpload.getInvalidFileMessage(), null).attr("invalidSizeMessage", fileUpload.getInvalidSizeMessage(), null).attr("fileLimitMessage", fileUpload.getFileLimitMessage(), null).attr("messageTemplate", fileUpload.getMessageTemplate(), null).attr("previewWidth", fileUpload.getPreviewWidth(), 80).attr("disabled", fileUpload.isDisabled(), false).callback("onstart", "function()", fileUpload.getOnstart()).callback("onerror", "function()", fileUpload.getOnerror()).callback("oncomplete", "function()", fileUpload.getOncomplete());
        if (fileUpload.getAllowTypes() != null) {
            wb.append(",allowTypes:").append(fileUpload.getAllowTypes());
        }
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        if (fileUpload.getMode().equals("simple")) {
            this.encodeSimpleMarkup(context, fileUpload);
        } else {
            this.encodeAdvancedMarkup(context, fileUpload);
        }
    }

    protected void encodeAdvancedMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String style = fileUpload.getStyle();
        String styleClass = fileUpload.getStyleClass();
        styleClass = styleClass == null ? "ui-fileupload ui-widget" : "ui-fileupload ui-widget " + styleClass;
        boolean disabled = fileUpload.isDisabled();
        writer.startElement("div", (UIComponent)fileUpload);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, styleClass);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("div", (UIComponent)fileUpload);
        writer.writeAttribute("class", (Object)"ui-fileupload-buttonbar ui-widget-header ui-corner-top", null);
        this.encodeChooseButton(context, fileUpload, disabled);
        if (!fileUpload.isAuto()) {
            this.encodeButton(context, fileUpload.getUploadLabel(), "ui-fileupload-upload", "ui-icon-arrowreturnthick-1-n");
            this.encodeButton(context, fileUpload.getCancelLabel(), "ui-fileupload-cancel", "ui-icon-cancel");
        }
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-fileupload-content ui-widget-content ui-corner-bottom", null);
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)"ui-fileupload-files", null);
        writer.startElement("tbody", null);
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeSimpleMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        this.encodeInputField(context, fileUpload, fileUpload.getClientId(context), "simple");
    }

    protected void encodeChooseButton(FacesContext context, FileUpload fileUpload, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String cssClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left ui-fileupload-choose";
        if (disabled) {
            cssClass = cssClass + " ui-state-disabled";
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)cssClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-icon-left ui-icon ui-c ui-icon-plusthick", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.writeText((Object)fileUpload.getLabel(), "value");
        writer.endElement("span");
        if (!disabled) {
            this.encodeInputField(context, fileUpload, clientId + "_input", "advanced");
        }
        writer.endElement("span");
    }

    protected void encodeInputField(FacesContext context, FileUpload fileUpload, String clientId, String mode) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"file", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (fileUpload.isMultiple()) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
        }
        if (fileUpload.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (mode.equals("simple")) {
            String style = fileUpload.getStyle();
            String styleClass = fileUpload.getStyleClass();
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
        }
        writer.endElement("input");
    }

    protected void encodeButton(FacesContext context, String label, String styleClass, String icon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String cssClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left ui-state-disabled " + styleClass;
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)cssClass, null);
        writer.writeAttribute("disabled", (Object)"disabled", null);
        String iconClass = "ui-button-icon-left ui-icon ui-c";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(iconClass + " " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.writeText((Object)label, "value");
        writer.endElement("span");
        writer.endElement("button");
    }
}

