/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.util.internal.GFileUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class DownloadAction
implements ExternalResource.ContentAndMetadataAction<Object> {
    private File destination;
    private ExternalResourceMetaData metaData;
    private final ExternalResourceName source;
    private final TemporaryFileProvider temporaryFileProvider;
    private final @Nullable Logger logger;

    public DownloadAction(ExternalResourceName source, TemporaryFileProvider temporaryFileProvider, @Nullable Logger logger) {
        this.source = source;
        this.temporaryFileProvider = temporaryFileProvider;
        this.logger = logger;
    }

    public Object execute(InputStream inputStream, ExternalResourceMetaData metaData) throws IOException {
        this.destination = this.temporaryFileProvider.createTemporaryFile("gradle_download", "bin", new String[0]);
        this.metaData = metaData;
        if (this.logger != null) {
            this.logger.info("Downloading {} to {}", (Object)this.source, (Object)this.destination);
        }
        if (this.destination.getParentFile() != null) {
            GFileUtils.mkdirs((File)this.destination.getParentFile());
        }
        try (FileOutputStream outputStream = new FileOutputStream(this.destination);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        return null;
    }

    public @NonNull File getDestination() {
        return this.destination;
    }

    public @Nullable ExternalResourceMetaData getMetaData() {
        return this.metaData;
    }
}

