﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ManagedPrefixList.h>
#include <aws/ec2/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class DescribeManagedPrefixListsResponse {
 public:
  AWS_EC2_API DescribeManagedPrefixListsResponse() = default;
  AWS_EC2_API DescribeManagedPrefixListsResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API DescribeManagedPrefixListsResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The token to use to retrieve the next page of results. This value is
   * <code>null</code> when there are no more results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeManagedPrefixListsResponse& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the prefix lists.</p>
   */
  inline const Aws::Vector<ManagedPrefixList>& GetPrefixLists() const { return m_prefixLists; }
  template <typename PrefixListsT = Aws::Vector<ManagedPrefixList>>
  void SetPrefixLists(PrefixListsT&& value) {
    m_prefixListsHasBeenSet = true;
    m_prefixLists = std::forward<PrefixListsT>(value);
  }
  template <typename PrefixListsT = Aws::Vector<ManagedPrefixList>>
  DescribeManagedPrefixListsResponse& WithPrefixLists(PrefixListsT&& value) {
    SetPrefixLists(std::forward<PrefixListsT>(value));
    return *this;
  }
  template <typename PrefixListsT = ManagedPrefixList>
  DescribeManagedPrefixListsResponse& AddPrefixLists(PrefixListsT&& value) {
    m_prefixListsHasBeenSet = true;
    m_prefixLists.emplace_back(std::forward<PrefixListsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeManagedPrefixListsResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<ManagedPrefixList> m_prefixLists;

  ResponseMetadata m_responseMetadata;
  bool m_nextTokenHasBeenSet = false;
  bool m_prefixListsHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
