﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ChimeSDKVoice {
namespace Model {

/**
 * <p>A target SIP media application and other details, such as priority and AWS
 * Region, to be specified in the SIP rule. Only one SIP rule per AWS Region can be
 * provided.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/SipRuleTargetApplication">AWS
 * API Reference</a></p>
 */
class SipRuleTargetApplication {
 public:
  AWS_CHIMESDKVOICE_API SipRuleTargetApplication() = default;
  AWS_CHIMESDKVOICE_API SipRuleTargetApplication(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHIMESDKVOICE_API SipRuleTargetApplication& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHIMESDKVOICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of a rule's target SIP media application.</p>
   */
  inline const Aws::String& GetSipMediaApplicationId() const { return m_sipMediaApplicationId; }
  inline bool SipMediaApplicationIdHasBeenSet() const { return m_sipMediaApplicationIdHasBeenSet; }
  template <typename SipMediaApplicationIdT = Aws::String>
  void SetSipMediaApplicationId(SipMediaApplicationIdT&& value) {
    m_sipMediaApplicationIdHasBeenSet = true;
    m_sipMediaApplicationId = std::forward<SipMediaApplicationIdT>(value);
  }
  template <typename SipMediaApplicationIdT = Aws::String>
  SipRuleTargetApplication& WithSipMediaApplicationId(SipMediaApplicationIdT&& value) {
    SetSipMediaApplicationId(std::forward<SipMediaApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The priority setting of a rule's target SIP media application.</p>
   */
  inline int GetPriority() const { return m_priority; }
  inline bool PriorityHasBeenSet() const { return m_priorityHasBeenSet; }
  inline void SetPriority(int value) {
    m_priorityHasBeenSet = true;
    m_priority = value;
  }
  inline SipRuleTargetApplication& WithPriority(int value) {
    SetPriority(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The AWS Region of a rule's target SIP media application.</p>
   */
  inline const Aws::String& GetAwsRegion() const { return m_awsRegion; }
  inline bool AwsRegionHasBeenSet() const { return m_awsRegionHasBeenSet; }
  template <typename AwsRegionT = Aws::String>
  void SetAwsRegion(AwsRegionT&& value) {
    m_awsRegionHasBeenSet = true;
    m_awsRegion = std::forward<AwsRegionT>(value);
  }
  template <typename AwsRegionT = Aws::String>
  SipRuleTargetApplication& WithAwsRegion(AwsRegionT&& value) {
    SetAwsRegion(std::forward<AwsRegionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_sipMediaApplicationId;

  int m_priority{0};

  Aws::String m_awsRegion;
  bool m_sipMediaApplicationIdHasBeenSet = false;
  bool m_priorityHasBeenSet = false;
  bool m_awsRegionHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
