/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit.jaxp13;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.custommonkey.xmlunit.NamespaceContext;

public class XMLUnitNamespaceContext2Jaxp13
implements javax.xml.namespace.NamespaceContext {
    private final Map nsMap;

    public XMLUnitNamespaceContext2Jaxp13(NamespaceContext ctx) {
        this.nsMap = XMLUnitNamespaceContext2Jaxp13.turnIntoMap(ctx);
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must not be null");
        }
        String uri = (String)this.nsMap.get(prefix);
        if (uri == null) {
            uri = "";
        }
        return uri;
    }

    public Iterator getPrefixes(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        TreeSet ts = new TreeSet();
        Iterator it = this.nsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!uri.equals(entry.getValue())) continue;
            ts.add(entry.getKey());
        }
        return ts.iterator();
    }

    public String getPrefix(String uri) {
        Iterator i = this.getPrefixes(uri);
        return i.hasNext() ? (String)i.next() : null;
    }

    private static Map turnIntoMap(NamespaceContext ctx) {
        HashMap<String, String> m = new HashMap<String, String>();
        Iterator i = ctx.getPrefixes();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = ctx.getNamespaceURI(prefix);
            if ("http://www.w3.org/XML/1998/namespace".equals(uri) || "http://www.w3.org/2000/xmlns/".equals(uri)) continue;
            m.put(prefix, uri);
        }
        m.put("xml", "http://www.w3.org/XML/1998/namespace");
        m.put("xmlns", "http://www.w3.org/2000/xmlns/");
        return m;
    }
}

