/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.deployment.impl;

import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.deployment.AEDeploymentConstants;
import org.apache.uima.aae.deployment.AsyncAEErrorConfiguration;
import org.apache.uima.aae.deployment.AsyncAggregateErrorConfiguration;
import org.apache.uima.aae.deployment.RemoteAEDeploymentMetaData;
import org.apache.uima.aae.deployment.impl.AEDeploymentDescription_Impl;
import org.apache.uima.aae.deployment.impl.DDParserUtil;
import org.apache.uima.aae.deployment.impl.DeploymentMetaData_Impl;
import org.apache.uima.aae.deployment.impl.InputQueue;
import org.apache.uima.aae.deployment.impl.InputQueue_Impl;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RemoteAEDeploymentMetaData_Impl
extends DeploymentMetaData_Impl
implements RemoteAEDeploymentMetaData,
AEDeploymentConstants {
    private static final long serialVersionUID = -6028698292841920067L;
    protected int casMultiplierPoolSize = 1;
    protected int initialFsHeapSize = 2000000;
    protected InputQueue inputQueue = new InputQueue_Impl();
    protected String replyQueueLocation = null;
    protected int remoteReplyQueueScaleout = -1;
    protected String serializerMethod = "xmi";
    protected AsyncAEErrorConfiguration errorConfiguration;
    protected ResourceSpecifier resourceSpecifier;
    protected Import importedAE;

    @Override
    public boolean isSet(int i) {
        return i != -1;
    }

    @Override
    public ResourceSpecifier getResourceSpecifier() {
        return this.resourceSpecifier;
    }

    @Override
    public void setResourceSpecifier(ResourceSpecifier rs, ResourceManager aResourceManager, boolean recursive) throws InvalidXMLException {
        this.resourceSpecifier = rs;
    }

    @Override
    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        String val;
        NamedNodeMap map = aElement.getAttributes();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Node item = map.item(i);
                String name = item.getNodeName();
                val = item.getNodeValue();
                val = val == null ? "" : val.trim();
                if ("key".equalsIgnoreCase(name)) {
                    this.setKey(val);
                    continue;
                }
                if ("remoteReplyQueueScaleout".equalsIgnoreCase(name)) {
                    try {
                        int n = Integer.parseInt(val);
                        if (n <= 0) {
                            throw new InvalidXMLException("invalid_element_text", new Object[]{n, "remoteReplyQueueScaleout"});
                        }
                        this.setRemoteReplyQueueScaleout(n);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidXMLException("unknown_element", new Object[]{"remoteReplyQueueScaleout"}, (Throwable)e);
                    }
                }
                throw new InvalidXMLException("unknown_element", new Object[]{name});
            }
        }
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("inputQueue".equalsIgnoreCase(elem.getTagName())) {
                this.checkAndSetInputQueueAttributes(elem);
                continue;
            }
            if ("casMultiplier".equalsIgnoreCase(elem.getTagName())) {
                int n;
                val = DDParserUtil.checkAndGetAttributeValue("casMultiplier", "poolSize", elem, true);
                if (val == null || val.trim().length() == 0) {
                    n = 0;
                } else {
                    try {
                        n = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        throw new InvalidXMLException("unknown_element", new Object[]{"poolSize"}, (Throwable)e);
                    }
                }
                this.setCasMultiplierPoolSize(n);
                val = DDParserUtil.checkAndGetAttributeValue("casMultiplier", "initialFsHeapSize", elem, false);
                if (val == null || val.trim().length() <= 0) continue;
                try {
                    this.initialFsHeapSize = Integer.parseInt(val);
                    continue;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new InvalidXMLException("unknown_element", new Object[]{"initialFsHeapSize"}, (Throwable)e);
                }
            }
            if ("replyQueue".equalsIgnoreCase(elem.getTagName())) {
                val = DDParserUtil.checkAndGetAttributeValue("replyQueue", "location", elem, false);
                if (val == null || val.trim().length() <= 0) continue;
                if ((val = val.trim()).equalsIgnoreCase("remote")) {
                    this.setReplyQueueLocation(val);
                    continue;
                }
                throw new InvalidXMLException("invalid_element_text", new Object[]{val, "location"});
            }
            if ("serializer".equalsIgnoreCase(elem.getTagName())) {
                this.setSerializerMethod(DDParserUtil.checkAndGetAttributeValue("serializer", "method", elem, true));
                continue;
            }
            if ("asyncAggregateErrorConfiguration".equalsIgnoreCase(elem.getTagName())) {
                this.errorConfiguration = (AsyncAggregateErrorConfiguration)aParser.buildObject(elem, aOptions);
                this.errorConfiguration.sParentObject(this);
                continue;
            }
            throw new InvalidXMLException("unknown_element", new Object[]{elem.getTagName()});
        }
        if (this.errorConfiguration == null) {
            this.errorConfiguration = (AsyncAEErrorConfiguration)UIMAFramework.getResourceSpecifierFactory().createObject(AsyncAggregateErrorConfiguration.class);
            this.setErrorConfiguration(this.errorConfiguration);
            this.errorConfiguration.sParentObject(this);
        }
    }

    protected void checkAndSetInputQueueAttributes(Element aElement) throws InvalidXMLException {
        NamedNodeMap map = aElement.getAttributes();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Node item = map.item(i);
                String name = item.getNodeName();
                String val = item.getNodeValue();
                val = val == null ? "" : val.trim();
                if ("endpoint".equalsIgnoreCase(name)) {
                    this.inputQueue.setEndPoint(val);
                    continue;
                }
                if ("brokerURL".equalsIgnoreCase(name)) {
                    this.inputQueue.setBrokerURL(val);
                    continue;
                }
                throw new InvalidXMLException("unknown_element", new Object[]{name});
            }
        }
        if (this.inputQueue.getEndPoint() == null) {
            throw new InvalidXMLException("element_not_found", new Object[]{"endpoint", "inputQueue"});
        }
        if (this.inputQueue.getBrokerURL() == null) {
            throw new InvalidXMLException("element_not_found", new Object[]{"brokerURL", "inputQueue"});
        }
    }

    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        if (this.getKey() != null && this.getKey().trim().length() > 0) {
            attrs.addAttribute("", "key", "key", null, this.getKey());
        }
        if (this.remoteReplyQueueScaleout > 0) {
            attrs.addAttribute("", "remoteReplyQueueScaleout", "remoteReplyQueueScaleout", null, "" + this.remoteReplyQueueScaleout);
        }
        aContentHandler.startElement("", "remoteAnalysisEngine", "remoteAnalysisEngine", attrs);
        attrs.clear();
        if (AEDeploymentDescription_Impl.isCASMultiplier(this.getResourceSpecifier()) && this.getCasMultiplierPoolSize() != -1) {
            attrs.addAttribute("", "poolSize", "poolSize", null, "" + this.getCasMultiplierPoolSize());
            attrs.addAttribute("", "initialFsHeapSize", "initialFsHeapSize", null, "" + this.initialFsHeapSize);
            aContentHandler.startElement("", "casMultiplier", "casMultiplier", attrs);
            aContentHandler.endElement("", "", "casMultiplier");
            attrs.clear();
        }
        if (this.inputQueue != null) {
            attrs.addAttribute("", "brokerURL", "brokerURL", null, this.inputQueue.getBrokerURL());
            attrs.addAttribute("", "endpoint", "endpoint", null, this.inputQueue.getEndPoint());
            aContentHandler.startElement("", "inputQueue", "inputQueue", attrs);
            aContentHandler.endElement("", "", "inputQueue");
            attrs.clear();
        }
        if (this.replyQueueLocation != null) {
            attrs.addAttribute("", "location", "location", null, this.replyQueueLocation);
            aContentHandler.startElement("", "replyQueue", "replyQueue", attrs);
            aContentHandler.endElement("", "", "replyQueue");
            attrs.clear();
        }
        if (this.getSerializerMethod() != null) {
            attrs.addAttribute("", "method", "method", null, this.getSerializerMethod());
            aContentHandler.startElement("", "serializer", "serializer", attrs);
            aContentHandler.endElement("", "", "serializer");
            attrs.clear();
        }
        if (this.errorConfiguration != null) {
            this.errorConfiguration.toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
        }
        aContentHandler.endElement("", "", "remoteAnalysisEngine");
    }

    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo(null, null);
    }

    @Override
    public int getCasMultiplierPoolSize() {
        return this.casMultiplierPoolSize;
    }

    @Override
    public void setCasMultiplierPoolSize(int casMultiplierPoolSize) {
        this.casMultiplierPoolSize = casMultiplierPoolSize;
    }

    @Override
    public AsyncAEErrorConfiguration getAsyncAEErrorConfiguration() {
        return this.errorConfiguration;
    }

    @Override
    public void setErrorConfiguration(AsyncAEErrorConfiguration errorConfiguration) {
        this.errorConfiguration = errorConfiguration;
    }

    @Override
    public String getReplyQueueLocation() {
        return this.replyQueueLocation;
    }

    @Override
    public void setReplyQueueLocation(String replyQueueLocation) {
        this.replyQueueLocation = replyQueueLocation;
    }

    @Override
    public String getSerializerMethod() {
        return this.serializerMethod;
    }

    @Override
    public void setSerializerMethod(String serializerMethod) {
        this.serializerMethod = serializerMethod;
    }

    @Override
    public InputQueue getInputQueue() {
        return this.inputQueue;
    }

    @Override
    public void setInputQueue(InputQueue inputQueue) {
        this.inputQueue = inputQueue;
    }

    @Override
    public Import getImportedAE() {
        return this.importedAE;
    }

    @Override
    public void setImportedAE(Import importedAE) {
        this.importedAE = importedAE;
    }

    @Override
    public int getInitialFsHeapSize() {
        return this.initialFsHeapSize;
    }

    @Override
    public void setInitialFsHeapSize(int initialFsHeapSize) {
        this.initialFsHeapSize = initialFsHeapSize;
    }

    @Override
    public int getRemoteReplyQueueScaleout() {
        return this.remoteReplyQueueScaleout;
    }

    @Override
    public void setRemoteReplyQueueScaleout(int concurrentConsumers) {
        this.remoteReplyQueueScaleout = concurrentConsumers;
    }
}

