/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogKeyVerify;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractDialogKeyVerifyJavaNames
extends AbstractDialogKeyVerify
implements VerifyKeyListener,
VerifyListener {
    @Override
    protected StyledText newSingleLineStyledText(Composite parent, String tip) {
        StyledText w = super.newSingleLineStyledText(parent, tip);
        w.addVerifyListener((VerifyListener)this);
        return w;
    }

    protected AbstractDialogKeyVerifyJavaNames(AbstractSection aSection, String title, String description) {
        super(aSection, title, description);
    }

    @Override
    public boolean verifyKeyChecks(VerifyEvent event) {
        if (event.keyCode == 13 || event.keyCode == 9) {
            return true;
        }
        if (Character.isJavaIdentifierPart(event.character)) {
            return true;
        }
        StyledText w = (StyledText)event.widget;
        String text = w.getText();
        int len = text.length();
        if (event.character == '.') {
            return len != 0;
        }
        return false;
    }

    public void verifyText(VerifyEvent event) {
        event.doit = true;
        String oldStr = ((StyledText)event.widget).getText();
        String newStr = oldStr.substring(0, event.start) + event.text + oldStr.substring(event.end);
        if (newStr.indexOf("..") >= 0) {
            event.doit = false;
            this.setErrorMessage("You cannot have two periods in a row.");
            return;
        }
        if (this.namePartStartsWithDigit(newStr)) {
            event.doit = false;
            this.setErrorMessage("Name parts cannot start with a digit.");
            return;
        }
    }

    private boolean namePartStartsWithDigit(String s) {
        if (null == s || s.length() == 0) {
            return false;
        }
        int testloc = 0;
        if (Character.isDigit(s.charAt(testloc))) {
            return true;
        }
        testloc = 1 + s.indexOf(46, testloc);
        while (testloc > 0 && testloc < s.length()) {
            if (Character.isDigit(s.charAt(testloc))) {
                return true;
            }
            testloc = 1 + s.indexOf(46, testloc);
        }
        return false;
    }
}

