/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import jakarta.ejb.Asynchronous;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.jee.ApplicationException;
import org.apache.openejb.jee.AsyncMethod;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.MethodParams;
import org.apache.openejb.jee.SessionBean;
import org.apache.xbean.finder.ClassFinder;

public class CheckAsynchronous
extends ValidationBase {
    @Override
    public void validate(EjbModule module) {
        HashSet<String> applicationExceptions = new HashSet<String>();
        for (ApplicationException applicationException : module.getEjbJar().getAssemblyDescriptor().getApplicationException()) {
            applicationExceptions.add(applicationException.getExceptionClass());
        }
        for (EnterpriseBean bean : module.getEjbJar().getEnterpriseBeans()) {
            Class ejbClass = null;
            try {
                ejbClass = this.loadClass(bean.getEjbClass());
            }
            catch (OpenEJBException e) {
                continue;
            }
            if (bean instanceof SessionBean) {
                SessionBean session = (SessionBean)bean;
                for (AsyncMethod asyncMethod : session.getAsyncMethod()) {
                    Method method = this.getMethod(ejbClass, asyncMethod);
                    if (method == null) {
                        this.fail(bean, "asynchronous.missing", asyncMethod.getMethodName(), ejbClass.getName(), this.getParameters(asyncMethod.getMethodParams()));
                        continue;
                    }
                    this.checkAsynchronousMethod(session, ejbClass, method, applicationExceptions);
                }
                for (String className : session.getAsynchronousClasses()) {
                    try {
                        Class cls = this.loadClass(className);
                        for (Method method : cls.getDeclaredMethods()) {
                            if (!Modifier.isPublic(method.getModifiers()) || method.isSynthetic()) continue;
                            this.checkAsynchronousMethod(session, ejbClass, method, applicationExceptions);
                        }
                    }
                    catch (OpenEJBException openEJBException) {
                    }
                }
                continue;
            }
            ClassFinder classFinder = new ClassFinder(new Class[]{ejbClass});
            for (Method method : classFinder.findAnnotatedMethods(Asynchronous.class)) {
                this.ignoredMethodAnnotation("Asynchronous", bean, bean.getEjbClass(), method.getName(), bean.getClass().getSimpleName());
            }
            if (ejbClass.getAnnotation(Asynchronous.class) == null) continue;
            this.ignoredClassAnnotation("Asynchronous", bean, bean.getEjbClass(), bean.getClass().getSimpleName());
        }
    }

    private void checkAsynchronousMethod(SessionBean bean, Class<?> ejbClass, Method method, Set<String> applicationExceptions) {
        String invalidThrowCauses;
        Class<?> retType = method.getReturnType();
        if (retType != Void.TYPE && retType != Future.class) {
            this.fail((EnterpriseBean)bean, "asynchronous.badReturnType", method.getName(), retType.getName(), ejbClass.getName());
        }
        if (retType == Void.TYPE && (invalidThrowCauses = this.checkThrowCauses(method.getExceptionTypes(), applicationExceptions)) != null) {
            this.fail((EnterpriseBean)bean, "asynchronous.badExceptionType", method.getName(), ejbClass.getName(), invalidThrowCauses);
        }
    }

    private String checkThrowCauses(Class<?>[] exceptionTypes, Set<String> applicationExceptions) {
        StringBuilder buffer = null;
        for (Class<?> exceptionType : exceptionTypes) {
            if (applicationExceptions.contains(exceptionType.getName()) || !Exception.class.isAssignableFrom(exceptionType) || RuntimeException.class.isAssignableFrom(exceptionType)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(exceptionType.getName());
                continue;
            }
            buffer.append(",").append(exceptionType.getName());
        }
        return buffer == null ? null : buffer.toString();
    }

    private Method getMethod(Class<?> clazz, AsyncMethod asyncMethod) {
        try {
            Class[] parameterTypes;
            MethodParams methodParams = asyncMethod.getMethodParams();
            if (methodParams != null) {
                parameterTypes = new Class[methodParams.getMethodParam().size()];
                int arrayIndex = 0;
                for (String parameterType : methodParams.getMethodParam()) {
                    parameterTypes[arrayIndex++] = this.loadClass(parameterType);
                }
            } else {
                parameterTypes = new Class[]{};
            }
            return clazz.getMethod(asyncMethod.getMethodName(), parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (OpenEJBException e) {
            throw new OpenEJBRuntimeException(e);
        }
    }
}

