/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.validation;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.apache.cxf.jaxrs.validation.ValidationUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.validation.BeanValidationOutInterceptor;

@Provider
public class JAXRSBeanValidationOutInterceptor
extends BeanValidationOutInterceptor
implements ContainerResponseFilter {
    private static final String OUT_VALIDATION_DONE = "out.bean.validation.done";
    private boolean supportMultipleValidations;

    public JAXRSBeanValidationOutInterceptor() {
    }

    public JAXRSBeanValidationOutInterceptor(String phase) {
        super(phase);
    }

    @Override
    protected Object getServiceObject(Message message) {
        return ValidationUtils.getResourceInstance(message);
    }

    @Override
    protected Object unwrapEntity(Object entity) {
        return entity instanceof Response ? ((Response)entity).getEntity() : entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filter(ContainerRequestContext in, ContainerResponseContext out) throws IOException {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (Boolean.TRUE != message.get(OUT_VALIDATION_DONE) || this.supportMultipleValidations) {
            try {
                super.handleMessage(message);
            }
            finally {
                message.put(OUT_VALIDATION_DONE, Boolean.TRUE);
            }
        }
    }

    public void setSupportMultipleValidations(boolean supportMultipleValidations) {
        this.supportMultipleValidations = supportMultipleValidations;
    }
}

