/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.springmvc;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.provider.AbstractResponseViewProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class SpringViewResolverProvider
extends AbstractResponseViewProvider {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SpringViewResolverProvider.class);
    private static final Logger LOG = LogUtils.getL7dLogger(SpringViewResolverProvider.class);
    private final ViewResolver viewResolver;
    private LocaleResolver localeResolver;

    public SpringViewResolverProvider(ViewResolver viewResolver, LocaleResolver localeResolver) {
        if (viewResolver == null) {
            throw new IllegalArgumentException("Argument viewResolver is required");
        }
        if (localeResolver == null) {
            throw new IllegalArgumentException("Argument localeResolver is required");
        }
        this.viewResolver = viewResolver;
        this.localeResolver = localeResolver;
    }

    private Locale getLocale() {
        return this.localeResolver.resolveLocale(this.getMessageContext().getHttpServletRequest());
    }

    @Override
    public void writeTo(Object o, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        View view = this.getView(clazz, o);
        String attributeName = this.getBeanName(o);
        Map<String, Object> model = Collections.singletonMap(attributeName, o);
        try {
            this.getMessageContext().put("http.request.redirected", Boolean.TRUE);
            this.logRedirection(view, attributeName, o);
            view.render(model, this.getMessageContext().getHttpServletRequest(), this.getMessageContext().getHttpServletResponse());
        }
        catch (Throwable ex) {
            this.handleViewRenderingException(view.toString(), ex);
        }
    }

    private void logRedirection(View view, String attributeName, Object o) {
        Level level;
        Level level2 = level = this.isLogRedirects() ? Level.INFO : Level.FINE;
        if (LOG.isLoggable(level)) {
            String message = new Message("RESPONSE_REDIRECTED_TO", BUNDLE, o.getClass().getName(), attributeName, view).toString();
            LOG.log(level, message);
        }
    }

    View getView(Class<?> cls, Object o) {
        String path = this.getResourcePath(cls, o);
        if (path != null) {
            return this.resolveView(path);
        }
        return null;
    }

    private View resolveView(String viewName) {
        try {
            return this.viewResolver.resolveViewName(viewName, this.getLocale());
        }
        catch (Exception ex) {
            LOG.warning(ExceptionUtils.getStackTrace(ex));
            throw ExceptionUtils.toInternalServerErrorException(ex, null);
        }
    }

    @Override
    protected boolean resourceAvailable(String resourceName) {
        return this.resolveView(resourceName) != null;
    }
}

