/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.dictionary.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.dictionary.serializer.EntryInserter;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringList;
import opennlp.tools.util.model.UncloseableInputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class DictionaryEntryPersistor {
    private static final SAXParserFactory SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
    private static final String SAX_FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String DICTIONARY_ELEMENT = "dictionary";
    private static final String ENTRY_ELEMENT = "entry";
    private static final String TOKEN_ELEMENT = "token";
    private static final String ATTRIBUTE_CASE_SENSITIVE = "case_sensitive";

    public static boolean create(InputStream in, EntryInserter inserter) throws IOException {
        DictionaryContenthandler profileContentHandler = new DictionaryContenthandler(inserter);
        try {
            XMLReader xmlReader = SAX_PARSER_FACTORY.newSAXParser().getXMLReader();
            xmlReader.setFeature(SAX_FEATURE_NAMESPACES, true);
            xmlReader.setContentHandler(profileContentHandler);
            xmlReader.parse(new InputSource(new UncloseableInputStream(in)));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new InvalidFormatException("The profile data stream has an invalid format!", e);
        }
        return profileContentHandler.mIsCaseSensitiveDictionary;
    }

    @Deprecated
    public static void serialize(OutputStream out, Iterator<Entry> entries) throws IOException {
        DictionaryEntryPersistor.serialize(out, entries, true);
    }

    public static void serialize(OutputStream out, Iterator<Entry> entries, boolean casesensitive) throws IOException {
        TransformerHandler hd;
        StreamResult streamResult = new StreamResult(out);
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            hd = tf.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new InvalidFormatException("The Transformer configuration must be valid!");
        }
        Transformer serializer = hd.getTransformer();
        serializer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        serializer.setOutputProperty("indent", "yes");
        hd.setResult(streamResult);
        try {
            hd.startDocument();
            AttributesImpl dictionaryAttributes = new AttributesImpl();
            dictionaryAttributes.addAttribute("", "", ATTRIBUTE_CASE_SENSITIVE, "", String.valueOf(casesensitive));
            hd.startElement("", "", DICTIONARY_ELEMENT, dictionaryAttributes);
            while (entries.hasNext()) {
                Entry entry = entries.next();
                DictionaryEntryPersistor.serializeEntry(hd, entry);
            }
            hd.endElement("", "", DICTIONARY_ELEMENT);
            hd.endDocument();
        }
        catch (SAXException e) {
            throw new IOException("Error during serialization: " + e.getMessage(), e);
        }
    }

    private static void serializeEntry(TransformerHandler hd, Entry entry) throws SAXException {
        AttributesImpl entryAttributes = new AttributesImpl();
        Iterator<String> it = entry.getAttributes().iterator();
        while (it.hasNext()) {
            String key = it.next();
            entryAttributes.addAttribute("", "", key, "", entry.getAttributes().getValue(key));
        }
        hd.startElement("", "", ENTRY_ELEMENT, entryAttributes);
        StringList tokens = entry.getTokens();
        for (String token : tokens) {
            hd.startElement("", "", TOKEN_ELEMENT, new AttributesImpl());
            hd.characters(token.toCharArray(), 0, token.length());
            hd.endElement("", "", TOKEN_ELEMENT);
        }
        hd.endElement("", "", ENTRY_ELEMENT);
    }

    private static class DictionaryContenthandler
    implements ContentHandler {
        private final EntryInserter mInserter;
        private boolean mIsInsideTokenElement;
        private boolean mIsCaseSensitiveDictionary;
        private final List<String> mTokenList = new LinkedList<String>();
        private final StringBuilder token = new StringBuilder();
        private Attributes mAttributes;

        private DictionaryContenthandler(EntryInserter inserter) {
            this.mInserter = inserter;
            this.mIsCaseSensitiveDictionary = true;
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes atts) throws SAXException {
            if (DictionaryEntryPersistor.DICTIONARY_ELEMENT.equals(localName)) {
                this.mAttributes = new Attributes();
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.mAttributes.setValue(atts.getLocalName(i), atts.getValue(i));
                }
                if (this.mAttributes.getValue(DictionaryEntryPersistor.ATTRIBUTE_CASE_SENSITIVE) != null) {
                    this.mIsCaseSensitiveDictionary = Boolean.parseBoolean(this.mAttributes.getValue(DictionaryEntryPersistor.ATTRIBUTE_CASE_SENSITIVE));
                }
                this.mAttributes = null;
            } else if (DictionaryEntryPersistor.ENTRY_ELEMENT.equals(localName)) {
                this.mAttributes = new Attributes();
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.mAttributes.setValue(atts.getLocalName(i), atts.getValue(i));
                }
            } else if (DictionaryEntryPersistor.TOKEN_ELEMENT.equals(localName)) {
                this.mIsInsideTokenElement = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mIsInsideTokenElement) {
                this.token.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (DictionaryEntryPersistor.TOKEN_ELEMENT.equals(localName)) {
                this.mTokenList.add(this.token.toString().trim());
                this.token.setLength(0);
                this.mIsInsideTokenElement = false;
            } else if (DictionaryEntryPersistor.ENTRY_ELEMENT.equals(localName)) {
                String[] tokens = this.mTokenList.toArray(new String[0]);
                Entry entry = new Entry(new StringList(tokens), this.mAttributes);
                try {
                    this.mInserter.insert(entry);
                }
                catch (InvalidFormatException e) {
                    throw new SAXException("Invalid dictionary format!", e);
                }
                this.mTokenList.clear();
                this.mAttributes = null;
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

