/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.DisableStrictChecks;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.PublishEvent;
import org.apache.tapestry5.annotations.RequestBody;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.annotations.StaticActivationContextValue;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.commons.util.UnknownValueException;
import org.apache.tapestry5.corelib.mixins.PublishServerSideEvents;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.RestSupport;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.internal.transform.EventHandlerMethodParameterProvider;
import org.apache.tapestry5.internal.transform.EventHandlerMethodParameterSource;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.Condition;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.LocalVariable;
import org.apache.tapestry5.plastic.LocalVariableCallback;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.MethodParameter;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.runtime.ComponentEvent;
import org.apache.tapestry5.runtime.Event;
import org.apache.tapestry5.runtime.PageLifecycleListener;
import org.apache.tapestry5.services.TransformConstants;
import org.apache.tapestry5.services.ValueEncoderSource;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class OnEventWorker
implements ComponentClassTransformWorker2 {
    private final Request request;
    private final ValueEncoderSource valueEncoderSource;
    private final RestSupport restSupport;
    private final ComponentClassCache classCache;
    private final OperationTracker operationTracker;
    private final InstructionBuilderCallback RETURN_TRUE = new InstructionBuilderCallback(){

        public void doBuild(InstructionBuilder builder) {
            builder.loadConstant((Object)true).returnResult();
        }
    };
    private static final Predicate<PlasticMethod> IS_EVENT_HANDLER = new Predicate<PlasticMethod>(){

        public boolean accept(PlasticMethod method) {
            return (this.hasCorrectPrefix(method) || this.hasAnnotation(method)) && !method.isOverride();
        }

        private boolean hasCorrectPrefix(PlasticMethod method) {
            return method.getDescription().methodName.startsWith("on");
        }

        private boolean hasAnnotation(PlasticMethod method) {
            return method.hasAnnotation(OnEvent.class);
        }
    };
    private final Map<String, EventHandlerMethodParameterProvider> parameterTypeToProvider = CollectionFactory.newMap();
    private static final Set<String> HTTP_EVENT_HANDLER_NAMES = InternalConstants.SUPPORTED_HTTP_METHOD_EVENT_HANDLER_METHOD_NAMES;
    private static final Set<String> HTTP_METHOD_EVENTS = InternalConstants.SUPPORTED_HTTP_METHOD_EVENTS;

    public OnEventWorker(Request request, ValueEncoderSource valueEncoderSource, ComponentClassCache classCache, OperationTracker operationTracker, RestSupport restSupport) {
        this.parameterTypeToProvider.put("java.lang.Object[]", new EventHandlerMethodParameterProvider(){

            @Override
            public Object valueForEventHandlerMethodParameter(ComponentEvent event) {
                return event.getContext();
            }
        });
        this.parameterTypeToProvider.put(List.class.getName(), new EventHandlerMethodParameterProvider(){

            @Override
            public Object valueForEventHandlerMethodParameter(ComponentEvent event) {
                return Arrays.asList(event.getContext());
            }
        });
        this.parameterTypeToProvider.put(EventContext.class.getName(), new EventHandlerMethodParameterProvider(){

            @Override
            public Object valueForEventHandlerMethodParameter(ComponentEvent event) {
                return event.getEventContext();
            }
        });
        this.request = request;
        this.valueEncoderSource = valueEncoderSource;
        this.classCache = classCache;
        this.operationTracker = operationTracker;
        this.restSupport = restSupport;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        Flow<PlasticMethod> methods = this.matchEventHandlerMethods(plasticClass);
        if (methods.isEmpty()) {
            return;
        }
        this.addEventHandlingLogic(plasticClass, support.isRootTransformation(), methods, model);
    }

    private void addEventHandlingLogic(PlasticClass plasticClass, boolean isRoot, Flow<PlasticMethod> plasticMethods, MutableComponentModel model) {
        Flow eventHandlerMethods = plasticMethods.map((Mapper)new Mapper<PlasticMethod, EventHandlerMethod>(){

            public EventHandlerMethod map(PlasticMethod element) {
                return new EventHandlerMethod(element);
            }
        });
        this.implementDispatchMethod(plasticClass, isRoot, model, (Flow<EventHandlerMethod>)eventHandlerMethods);
        this.addComponentIdValidationLogicOnPageLoad(plasticClass, (Flow<EventHandlerMethod>)eventHandlerMethods);
        this.addPublishEventInfo((Flow<EventHandlerMethod>)eventHandlerMethods, model);
    }

    private void addPublishEventInfo(Flow<EventHandlerMethod> eventHandlerMethods, MutableComponentModel model) {
        JSONArray publishEvents = new JSONArray();
        for (EventHandlerMethod eventHandlerMethod : eventHandlerMethods) {
            if (eventHandlerMethod.publishEvent == null) continue;
            publishEvents.add((Object)eventHandlerMethod.eventType.toLowerCase());
        }
        if (publishEvents.size() > 0) {
            model.addMixinClassName(PublishServerSideEvents.class.getName(), "after:*");
            model.setMeta("meta.publish-component-events", publishEvents.toString());
        }
    }

    private void addComponentIdValidationLogicOnPageLoad(PlasticClass plasticClass, Flow<EventHandlerMethod> eventHandlerMethods) {
        ComponentIdValidator[] validators = this.extractComponentIdValidators(eventHandlerMethods);
        if (validators.length > 0) {
            plasticClass.introduceInterface(PageLifecycleListener.class);
            plasticClass.introduceMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_DESCRIPTION).addAdvice((MethodAdvice)new ValidateComponentIds(validators));
        }
    }

    private ComponentIdValidator[] extractComponentIdValidators(Flow<EventHandlerMethod> eventHandlerMethods) {
        return (ComponentIdValidator[])((Flow)eventHandlerMethods.map((Mapper)new Mapper<EventHandlerMethod, ComponentIdValidator>(){

            public ComponentIdValidator map(EventHandlerMethod element) {
                if (element.componentId.equals("")) {
                    return null;
                }
                if (element.method.getAnnotation(DisableStrictChecks.class) != null) {
                    return null;
                }
                return new ComponentIdValidator(element.componentId, element.method.getMethodIdentifier());
            }
        }).removeNulls()).toArray(ComponentIdValidator.class);
    }

    private void implementDispatchMethod(final PlasticClass plasticClass, final boolean isRoot, final MutableComponentModel model, final Flow<EventHandlerMethod> eventHandlerMethods) {
        plasticClass.introduceMethod(TransformConstants.DISPATCH_COMPONENT_EVENT_DESCRIPTION).changeImplementation(new InstructionBuilderCallback(){

            public void doBuild(InstructionBuilder builder) {
                builder.startVariable("boolean", new LocalVariableCallback(){

                    public void doBuild(LocalVariable resultVariable, InstructionBuilder builder) {
                        if (!isRoot) {
                            builder.loadThis().loadArguments().invokeSpecial(plasticClass.getSuperClassName(), TransformConstants.DISPATCH_COMPONENT_EVENT_DESCRIPTION);
                            builder.storeVariable(resultVariable);
                            builder.loadArgument(0).invoke(Event.class, Boolean.TYPE, "isAborted", new Class[0]);
                            builder.when(Condition.NON_ZERO, OnEventWorker.this.RETURN_TRUE);
                        } else {
                            builder.loadConstant((Object)false).storeVariable(resultVariable);
                        }
                        boolean hasRestEndpointEventHandlerMethod = false;
                        JSONArray restEndpointEventHandlerMethods = null;
                        for (EventHandlerMethod method : eventHandlerMethods) {
                            String methodName;
                            OnEvent onEvent;
                            method.buildMatchAndInvocation(builder, resultVariable);
                            model.addEventHandler(method.eventType);
                            if (method.handleActivationEventContext) {
                                model.doHandleActivationEventContext();
                            }
                            if (!OnEventWorker.isRestEndpointEventHandlerMethod(onEvent = (OnEvent)method.method.getAnnotation(OnEvent.class), methodName = method.method.getDescription().methodName)) continue;
                            hasRestEndpointEventHandlerMethod = true;
                            if (restEndpointEventHandlerMethods == null) {
                                restEndpointEventHandlerMethods = new JSONArray();
                            }
                            JSONObject methodMeta = new JSONObject();
                            methodMeta.put("name", (Object)methodName);
                            JSONArray parameters = new JSONArray();
                            for (MethodParameter parameter : method.method.getParameters()) {
                                parameters.add((Object)parameter.getType());
                            }
                            methodMeta.put("parameters", (Object)parameters);
                            restEndpointEventHandlerMethods.add((Object)methodMeta);
                        }
                        if (model.isPage()) {
                            model.setMeta("restEndpointEventHandlerMethodsPresent", hasRestEndpointEventHandlerMethod ? "true" : "false");
                        }
                        if (restEndpointEventHandlerMethods != null) {
                            model.setMeta("restEndpointEventHandlerMethods", restEndpointEventHandlerMethods.toCompactString());
                        }
                        builder.loadVariable(resultVariable).returnResult();
                    }
                });
            }
        });
    }

    private Flow<PlasticMethod> matchEventHandlerMethods(PlasticClass plasticClass) {
        return (Flow)F.flow((Collection)plasticClass.getMethods()).filter(IS_EVENT_HANDLER);
    }

    private EventHandlerMethodParameterProvider createRequestBodyProvider(PlasticMethod method, int parameterIndex, String parameterTypeName, boolean allowEmpty) {
        String methodIdentifier = method.getMethodIdentifier();
        return event -> {
            Invokable operation = () -> {
                Class parameterType = this.classCache.forName(parameterTypeName);
                Optional result = this.restSupport.getRequestBodyAs(parameterType);
                if (!allowEmpty && !result.isPresent()) {
                    throw new RuntimeException(String.format("The request has an empty body and %s has one parameter with @RequestBody(allowEmpty=false)", methodIdentifier));
                }
                return result.orElse(null);
            };
            return this.operationTracker.invoke("Converting HTTP request body for @RequestBody parameter", operation);
        };
    }

    private EventHandlerMethodParameterProvider createQueryParameterProvider(PlasticMethod method, final int parameterIndex, final String parameterName, final String parameterTypeName, final boolean allowBlank) {
        final String methodIdentifier = method.getMethodIdentifier();
        return new EventHandlerMethodParameterProvider(){

            @Override
            public Object valueForEventHandlerMethodParameter(ComponentEvent event) {
                try {
                    Object[] value;
                    Class<?> parameterType = OnEventWorker.this.classCache.forName(parameterTypeName);
                    boolean isArray = parameterType.isArray();
                    if (isArray) {
                        parameterType = parameterType.getComponentType();
                    }
                    ValueEncoder<?> valueEncoder = OnEventWorker.this.valueEncoderSource.getValueEncoder(parameterType);
                    String parameterValue = OnEventWorker.this.request.getParameter(parameterName);
                    if (!allowBlank && InternalUtils.isBlank((String)parameterValue)) {
                        throw new RuntimeException(String.format("The value for query parameter '%s' was blank, but a non-blank value is needed.", parameterName));
                    }
                    if (!isArray) {
                        value = this.coerce(parameterName, parameterType, parameterValue, valueEncoder, allowBlank);
                    } else {
                        String[] parameterValues = OnEventWorker.this.request.getParameters(parameterName);
                        Object[] array = (Object[])Array.newInstance(parameterType, parameterValues.length);
                        for (int i = 0; i < parameterValues.length; ++i) {
                            array[i] = this.coerce(parameterName, parameterType, parameterValues[i], valueEncoder, allowBlank);
                        }
                        value = array;
                    }
                    return value;
                }
                catch (Exception ex) {
                    throw new RuntimeException(String.format("Unable process query parameter '%s' as parameter #%d of event handler method %s: %s", parameterName, parameterIndex + 1, methodIdentifier, ExceptionUtils.toMessage((Throwable)ex)), ex);
                }
            }

            private Object coerce(String parameterName2, Class parameterType, String parameterValue, ValueEncoder valueEncoder, boolean allowBlank2) {
                if (!allowBlank2 && InternalUtils.isBlank((String)parameterValue)) {
                    throw new RuntimeException(String.format("The value for query parameter '%s' was blank, but a non-blank value is needed.", parameterName2));
                }
                Object value = valueEncoder.toValue(parameterValue);
                if (parameterType.isPrimitive() && value == null) {
                    throw new RuntimeException(String.format("Query parameter '%s' evaluates to null, but the event method parameter is type %s, a primitive.", parameterName2, parameterType.getName()));
                }
                return value;
            }
        };
    }

    private EventHandlerMethodParameterProvider createEventContextProvider(final String type, final int parameterIndex) {
        return new EventHandlerMethodParameterProvider(){

            @Override
            public Object valueForEventHandlerMethodParameter(ComponentEvent event) {
                return event.coerceContext(parameterIndex, type);
            }
        };
    }

    private String extractComponentId(String methodName, OnEvent annotation) {
        if (annotation != null) {
            return annotation.component();
        }
        int fromx = methodName.indexOf("From");
        if (fromx < 0) {
            return "";
        }
        return methodName.substring(fromx + 4);
    }

    private String extractEventType(String methodName, OnEvent annotation) {
        if (annotation != null) {
            return annotation.value();
        }
        int fromx = methodName.indexOf("From");
        return fromx == -1 ? methodName.substring(2) : methodName.substring(2, fromx);
    }

    public static boolean isRestEndpointEventHandlerMethod(OnEvent onEvent, String methodName) {
        return onEvent != null && HTTP_METHOD_EVENTS.contains(onEvent.value().toLowerCase()) || HTTP_EVENT_HANDLER_NAMES.contains(methodName.toLowerCase());
    }

    class EventHandlerMethod {
        final PlasticMethod method;
        final MethodDescription description;
        final String eventType;
        final String componentId;
        final EventHandlerMethodParameterSource parameterSource;
        int minContextValues = 0;
        boolean handleActivationEventContext = false;
        final String[] staticActivationContextValues;
        final PublishEvent publishEvent;
        private final Pattern WHITESPACE = Pattern.compile(".*\\s.*");

        EventHandlerMethod(PlasticMethod method) {
            this.method = method;
            this.description = method.getDescription();
            this.parameterSource = this.buildSource();
            String methodName = method.getDescription().methodName;
            OnEvent onEvent = (OnEvent)method.getAnnotation(OnEvent.class);
            this.eventType = OnEventWorker.this.extractEventType(methodName, onEvent);
            this.componentId = OnEventWorker.this.extractComponentId(methodName, onEvent);
            this.publishEvent = (PublishEvent)method.getAnnotation(PublishEvent.class);
            this.staticActivationContextValues = this.extractStaticActivationContextValues(method);
        }

        private String[] extractStaticActivationContextValues(PlasticMethod method) {
            String[] values = null;
            for (int i = 0; i < method.getParameters().size(); ++i) {
                String value;
                MethodParameter parameter = (MethodParameter)method.getParameters().get(i);
                StaticActivationContextValue staticValue = (StaticActivationContextValue)parameter.getAnnotation(StaticActivationContextValue.class);
                if (staticValue == null) continue;
                if (values == null) {
                    values = new String[method.getParameters().size()];
                }
                if ((value = staticValue.value()) != null && !value.isEmpty() && !this.WHITESPACE.matcher(value).matches()) {
                    values[i] = value;
                    continue;
                }
                throw new RuntimeException(String.format("%s has at least one parameter with a @%s annotation with an invalid value (empty string or value containing whitespace)", method.getMethodIdentifier(), StaticActivationContextValue.class.getSimpleName()));
            }
            return values;
        }

        void buildMatchAndInvocation(InstructionBuilder builder, final LocalVariable resultVariable) {
            final PlasticField sourceField = this.parameterSource == null ? null : this.method.getPlasticClass().introduceField(EventHandlerMethodParameterSource.class, this.description.methodName + "$parameterSource").inject((Object)this.parameterSource);
            PlasticField staticActivationContextValueField = this.staticActivationContextValues == null ? null : this.method.getPlasticClass().introduceField(String[].class, this.description.methodName + "$staticActivationContextValues").inject((Object)this.staticActivationContextValues);
            builder.loadArgument(0).loadConstant((Object)this.eventType).loadConstant((Object)this.componentId).loadConstant((Object)this.minContextValues);
            if (staticActivationContextValueField != null) {
                builder.loadThis().getField(staticActivationContextValueField);
            } else {
                builder.loadNull();
            }
            builder.invoke(ComponentEvent.class, Boolean.TYPE, "matches", new Class[]{String.class, String.class, Integer.TYPE, String[].class});
            builder.when(Condition.NON_ZERO, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadArgument(0).loadConstant((Object)EventHandlerMethod.this.method.getMethodIdentifier()).invoke(Event.class, Void.TYPE, "setMethodDescription", new Class[]{String.class});
                    builder.loadThis();
                    int count = EventHandlerMethod.this.description.argumentTypes.length;
                    for (int i = 0; i < count; ++i) {
                        builder.loadThis().getField(sourceField).loadArgument(0).loadConstant((Object)i);
                        builder.invoke(EventHandlerMethodParameterSource.class, Object.class, "get", new Class[]{ComponentEvent.class, Integer.TYPE});
                        builder.castOrUnbox(EventHandlerMethod.this.description.argumentTypes[i]);
                    }
                    builder.invokeVirtual(EventHandlerMethod.this.method);
                    if (!EventHandlerMethod.this.method.isVoid()) {
                        builder.boxPrimitive(EventHandlerMethod.this.description.returnType);
                        builder.loadArgument(0).swap();
                        builder.invoke(Event.class, Boolean.TYPE, "storeResult", new Class[]{Object.class});
                        builder.when(Condition.NON_ZERO, OnEventWorker.this.RETURN_TRUE);
                    }
                    builder.loadConstant((Object)true).storeVariable(resultVariable);
                }
            });
        }

        private EventHandlerMethodParameterSource buildSource() {
            String[] parameterTypes = this.method.getDescription().argumentTypes;
            if (parameterTypes.length == 0) {
                return null;
            }
            List providers = CollectionFactory.newList();
            int contextIndex = 0;
            boolean hasBodyRequestParameters = false;
            for (int i = 0; i < parameterTypes.length; ++i) {
                String type = parameterTypes[i];
                EventHandlerMethodParameterProvider provider = (EventHandlerMethodParameterProvider)OnEventWorker.this.parameterTypeToProvider.get(type);
                if (provider != null) {
                    providers.add(provider);
                    this.handleActivationEventContext = true;
                    continue;
                }
                RequestParameter parameterAnnotation = (RequestParameter)((MethodParameter)this.method.getParameters().get(i)).getAnnotation(RequestParameter.class);
                if (parameterAnnotation != null) {
                    String parameterName = parameterAnnotation.value();
                    providers.add(OnEventWorker.this.createQueryParameterProvider(this.method, i, parameterName, type, parameterAnnotation.allowBlank()));
                    continue;
                }
                RequestBody bodyAnnotation = (RequestBody)((MethodParameter)this.method.getParameters().get(i)).getAnnotation(RequestBody.class);
                if (bodyAnnotation != null) {
                    if (!hasBodyRequestParameters) {
                        providers.add(OnEventWorker.this.createRequestBodyProvider(this.method, i, type, bodyAnnotation.allowEmpty()));
                        hasBodyRequestParameters = true;
                        continue;
                    }
                    throw new RuntimeException(String.format("Method %s has more than one @RequestBody parameter", this.method.getDescription()));
                }
                providers.add(OnEventWorker.this.createEventContextProvider(type, contextIndex++));
            }
            this.minContextValues = contextIndex;
            EventHandlerMethodParameterProvider[] providerArray = providers.toArray(new EventHandlerMethodParameterProvider[providers.size()]);
            return new EventHandlerMethodParameterSource(this.method.getMethodIdentifier(), OnEventWorker.this.operationTracker, providerArray);
        }
    }

    class ComponentIdValidator {
        final String componentId;
        final String methodIdentifier;

        ComponentIdValidator(String componentId, String methodIdentifier) {
            this.componentId = componentId;
            this.methodIdentifier = methodIdentifier;
        }

        void validate(ComponentResources resources) {
            try {
                resources.getEmbeddedComponent(this.componentId);
            }
            catch (UnknownValueException ex) {
                throw new TapestryException(String.format("Method %s references component id '%s' which does not exist.", this.methodIdentifier, this.componentId), resources.getLocation(), (Throwable)ex);
            }
        }
    }

    class ValidateComponentIds
    implements MethodAdvice {
        final ComponentIdValidator[] validators;

        ValidateComponentIds(ComponentIdValidator[] validators) {
            this.validators = validators;
        }

        public void advise(MethodInvocation invocation) {
            ComponentResources resources = (ComponentResources)invocation.getInstanceContext().get(ComponentResources.class);
            for (ComponentIdValidator validator : this.validators) {
                validator.validate(resources);
            }
            invocation.proceed();
        }
    }
}

