/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.commons.internal.util.LockSupport;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class NamedSet<T>
extends LockSupport {
    private NamedRef<T> first;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNames() {
        try {
            this.acquireReadLock();
            Set result = CollectionFactory.newSet();
            NamedRef<T> cursor = this.first;
            while (cursor != null) {
                result.add(cursor.name);
                cursor = cursor.next;
            }
            Set set = result;
            return set;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public Set<T> getValues() {
        Set result = CollectionFactory.newSet();
        this.addValues(result);
        return result;
    }

    private void addValues(Collection<T> result) {
        try {
            this.acquireReadLock();
            NamedRef<T> cursor = this.first;
            while (cursor != null) {
                result.add(cursor.value);
                cursor = cursor.next;
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String name) {
        try {
            this.acquireReadLock();
            NamedRef<T> cursor = this.first;
            while (cursor != null) {
                if (cursor.name.equalsIgnoreCase(name)) {
                    Object t = cursor.value;
                    return t;
                }
                cursor = cursor.next;
            }
            T t = null;
            return t;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String name, T newValue) {
        assert (InternalUtils.isNonBlank((String)name));
        assert (newValue != null);
        try {
            this.takeWriteLock();
            NamedRef<T> prev = null;
            NamedRef<T> cursor = this.first;
            while (cursor != null) {
                if (cursor.name.equalsIgnoreCase(name)) {
                    cursor.name = name;
                    cursor.value = newValue;
                    return;
                }
                prev = cursor;
                cursor = cursor.next;
            }
            NamedRef<T> newRef = new NamedRef<T>(name, newValue);
            if (prev == null) {
                this.first = newRef;
            } else {
                prev.next = newRef;
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void eachValue(Worker<T> worker) {
        List result = CollectionFactory.newList();
        this.addValues(result);
        F.flow((Collection)result).each(worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfNew(String name, T newValue) {
        assert (InternalUtils.isNonBlank((String)name));
        assert (newValue != null);
        try {
            this.takeWriteLock();
            NamedRef<T> prev = null;
            NamedRef<T> cursor = this.first;
            while (cursor != null) {
                if (cursor.name.equalsIgnoreCase(name)) {
                    boolean bl = false;
                    return bl;
                }
                prev = cursor;
                cursor = cursor.next;
            }
            NamedRef<T> newRef = new NamedRef<T>(name, newValue);
            if (prev == null) {
                this.first = newRef;
            } else {
                prev.next = newRef;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public static <T> NamedSet<T> create() {
        return new NamedSet<T>();
    }

    public static <T> T get(NamedSet<T> set, String name) {
        return set == null ? null : (T)set.get(name);
    }

    public static Set<String> getNames(NamedSet<?> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return set.getNames();
    }

    public static <T> Set<T> getValues(NamedSet<T> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return set.getValues();
    }

    private static class NamedRef<T> {
        NamedRef<T> next;
        String name;
        T value;

        public NamedRef(String name, T value) {
            this.name = name;
            this.value = value;
        }
    }
}

