/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.internal.services.MessagesBundle;
import org.apache.tapestry5.internal.services.MessagesSourceImpl;
import org.apache.tapestry5.internal.services.ReloadHelper;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.ioc.services.UpdateListener;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.messages.ComponentMessagesSource;
import org.apache.tapestry5.services.messages.PropertiesFileParser;
import org.apache.tapestry5.services.pageload.ComponentRequestSelectorAnalyzer;
import org.apache.tapestry5.services.pageload.ComponentResourceLocator;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.slf4j.Logger;

public class ComponentMessagesSourceImpl
implements ComponentMessagesSource,
UpdateListener {
    private final MessagesSourceImpl messagesSource;
    private final MessagesBundle appCatalogBundle;
    private final ComponentRequestSelectorAnalyzer componentRequestSelectorAnalyzer;
    private final ThreadLocale threadLocale;

    public ComponentMessagesSourceImpl(@Symbol(value="tapestry.production-mode") boolean productionMode, @Symbol(value="tapestry.multiple-classloaders") boolean multipleClassLoaders, List<Resource> appCatalogResources, PropertiesFileParser parser, ComponentResourceLocator resourceLocator, ClasspathURLConverter classpathURLConverter, ComponentRequestSelectorAnalyzer componentRequestSelectorAnalyzer, ThreadLocale threadLocale, ComponentClassResolver componentClassResolver, Logger logger) {
        this(productionMode, multipleClassLoaders, appCatalogResources, resourceLocator, parser, new URLChangeTracker(classpathURLConverter), componentRequestSelectorAnalyzer, threadLocale, componentClassResolver, logger);
    }

    ComponentMessagesSourceImpl(boolean productionMode, boolean multipleClassLoaders, Resource appCatalogResource, ComponentResourceLocator resourceLocator, PropertiesFileParser parser, URLChangeTracker tracker, ComponentRequestSelectorAnalyzer componentRequestSelectorAnalyzer, ThreadLocale threadLocale, ComponentClassResolver componentClassResolver, Logger logger) {
        this(productionMode, multipleClassLoaders, Arrays.asList(appCatalogResource), resourceLocator, parser, tracker, componentRequestSelectorAnalyzer, threadLocale, componentClassResolver, logger);
    }

    ComponentMessagesSourceImpl(boolean productionMode, boolean multipleClassLoaders, List<Resource> appCatalogResources, ComponentResourceLocator resourceLocator, PropertiesFileParser parser, URLChangeTracker tracker, ComponentRequestSelectorAnalyzer componentRequestSelectorAnalyzer, ThreadLocale threadLocale, ComponentClassResolver componentClassResolver, Logger logger) {
        this.messagesSource = new MessagesSourceImpl(productionMode, multipleClassLoaders, productionMode ? null : tracker, resourceLocator, parser, componentClassResolver, logger);
        this.appCatalogBundle = this.createAppCatalogBundle(appCatalogResources);
        this.componentRequestSelectorAnalyzer = componentRequestSelectorAnalyzer;
        this.threadLocale = threadLocale;
    }

    @PostInjection
    public void setupReload(ReloadHelper reloadHelper) {
        reloadHelper.addReloadCallback(new Runnable(){

            @Override
            public void run() {
                ComponentMessagesSourceImpl.this.messagesSource.invalidate();
            }
        });
    }

    public void checkForUpdates() {
        this.messagesSource.checkForUpdates();
    }

    @Override
    public Messages getMessages(ComponentModel componentModel, Locale locale) {
        return this.getMessagesWithForcedLocale(() -> this.getMessages(componentModel, this.componentRequestSelectorAnalyzer.buildSelectorForRequest()), locale);
    }

    private Messages getMessagesWithForcedLocale(Callable<Messages> callable, Locale locale) {
        Locale original = this.threadLocale.getLocale();
        try {
            this.threadLocale.setLocale(locale);
            Messages messages = callable.call();
            return messages;
        }
        catch (Exception e) {
            throw new TapestryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.threadLocale.setLocale(original);
        }
    }

    @Override
    public Messages getMessages(ComponentModel componentModel, ComponentResourceSelector selector) {
        ComponentModelBundle bundle = new ComponentModelBundle(componentModel);
        return this.messagesSource.getMessages(bundle, selector);
    }

    @Override
    public Messages getApplicationCatalog(Locale locale) {
        return this.getMessagesWithForcedLocale(() -> this.messagesSource.getMessages(this.appCatalogBundle, this.componentRequestSelectorAnalyzer.buildSelectorForRequest()), locale);
    }

    private MessagesBundle createAppCatalogBundle(List<Resource> resources) {
        MessagesBundle current = null;
        for (Resource r : resources) {
            current = this.createMessagesBundle(r, current);
        }
        return current;
    }

    private MessagesBundle createMessagesBundle(final Resource resource, final MessagesBundle parent) {
        return new MessagesBundle(){

            @Override
            public Resource getBaseResource() {
                return resource;
            }

            @Override
            public Object getId() {
                return resource.getPath();
            }

            @Override
            public MessagesBundle getParent() {
                return parent;
            }
        };
    }

    @Override
    public InvalidationEventHub getInvalidationEventHub() {
        return this.messagesSource;
    }

    private class ComponentModelBundle
    implements MessagesBundle {
        private final ComponentModel model;

        public ComponentModelBundle(ComponentModel model) {
            this.model = model;
        }

        @Override
        public Resource getBaseResource() {
            return this.model.getBaseResource();
        }

        @Override
        public Object getId() {
            return this.model.getComponentClassName();
        }

        @Override
        public MessagesBundle getParent() {
            ComponentModel parentModel = this.model.getParentModel();
            if (parentModel == null) {
                return ComponentMessagesSourceImpl.this.appCatalogBundle;
            }
            return new ComponentModelBundle(parentModel);
        }
    }
}

