/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.decode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.decode.Decoder;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DecoderBin
extends Decoder {
    private static final long serialVersionUID = -3784249774608228805L;
    private int[] _numBins;
    private double[][] _binMins = null;
    private double[][] _binMaxs = null;

    public DecoderBin() {
        super(null, null);
    }

    protected DecoderBin(Types.ValueType[] schema, int[] binCols) {
        super(schema, binCols);
    }

    @Override
    public FrameBlock decode(MatrixBlock in, FrameBlock out) {
        out.ensureAllocatedColumns(in.getNumRows());
        this.decode(in, out, 0, in.getNumRows());
        return out;
    }

    @Override
    public void decode(MatrixBlock in, FrameBlock out, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            for (int j = 0; j < this._colList.length; ++j) {
                Array<?> a = out.getColumn(this._colList[j] - 1);
                double val = in.get(i, this._colList[j] - 1);
                if (!Double.isNaN(val)) {
                    int key = (int)Math.round(val);
                    double bmin = this._binMins[j][key - 1];
                    double bmax = this._binMaxs[j][key - 1];
                    double oval = bmin + (bmax - bmin) / 2.0 + (val - (double)key) * (bmax - bmin);
                    a.set(i, oval);
                    continue;
                }
                a.set(i, val);
            }
        }
    }

    @Override
    public Decoder subRangeDecoder(int colStart, int colEnd, int dummycodedOffset) {
        throw new NotImplementedException();
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._numBins = new int[this._colList.length];
        this._binMins = new double[this._colList.length][];
        this._binMaxs = new double[this._colList.length][];
        block0: for (int j = 0; j < this._colList.length; ++j) {
            int numBins = (int)meta.getColumnMetadata(this._colList[j] - 1).getNumDistinct();
            this._binMins[j] = new double[numBins];
            this._binMaxs[j] = new double[numBins];
            int i = 0;
            while (i < meta.getNumRows() & i < numBins) {
                if (meta.get(i, this._colList[j] - 1) == null) {
                    if (i + 1 >= numBins) continue block0;
                    throw new DMLRuntimeException("Did not reach number of bins: " + (i + 1) + "/" + numBins);
                }
                String[] parts = UtilFunctions.splitRecodeEntry(meta.get(i, this._colList[j] - 1).toString());
                this._binMins[j][i] = Double.parseDouble(parts[0]);
                this._binMaxs[j][i] = Double.parseDouble(parts[1]);
                ++i;
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        for (int i = 0; i < this._colList.length; ++i) {
            int len = this._numBins[i];
            out.writeInt(len);
            for (int j = 0; j < len; ++j) {
                out.writeDouble(this._binMins[i][j]);
                out.writeDouble(this._binMaxs[i][j]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        super.readExternal(in);
        this._numBins = new int[this._colList.length];
        this._binMins = new double[this._colList.length][];
        this._binMaxs = new double[this._colList.length][];
        for (int i = 0; i < this._colList.length; ++i) {
            int len;
            this._numBins[i] = len = in.readInt();
            for (int j = 0; j < len; ++j) {
                this._binMins[i][j] = in.readDouble();
                this._binMaxs[i][j] = in.readDouble();
            }
        }
    }
}

