/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.blockaliasmap.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TextFileRegionAliasMap
extends BlockAliasMap<FileRegion>
implements Configurable {
    private Configuration conf;
    private ReaderOptions readerOpts = TextReader.defaults();
    private WriterOptions writerOpts = TextWriter.defaults();
    public static final Logger LOG = LoggerFactory.getLogger(TextFileRegionAliasMap.class);

    public void setConf(Configuration conf) {
        this.readerOpts.setConf(conf);
        this.writerOpts.setConf(conf);
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public BlockAliasMap.Reader<FileRegion> getReader(BlockAliasMap.Reader.Options opts, String blockPoolID) throws IOException {
        if (null == opts) {
            opts = this.readerOpts;
        }
        if (!(opts instanceof ReaderOptions)) {
            throw new IllegalArgumentException("Invalid options " + opts.getClass());
        }
        ReaderOptions o = (ReaderOptions)opts;
        Configuration readerConf = null == o.getConf() ? new Configuration() : o.getConf();
        return this.createReader(o.file, o.delim, readerConf, blockPoolID);
    }

    @VisibleForTesting
    TextReader createReader(Path file, String delim, Configuration cfg, String blockPoolID) throws IOException {
        FileSystem fs = file.getFileSystem(cfg);
        if (fs instanceof LocalFileSystem) {
            fs = ((LocalFileSystem)fs).getRaw();
        }
        CompressionCodecFactory factory = new CompressionCodecFactory(cfg);
        CompressionCodec codec = factory.getCodec(file);
        String filename = TextFileRegionAliasMap.fileNameFromBlockPoolID(blockPoolID);
        if (codec != null) {
            filename = filename + codec.getDefaultExtension();
        }
        Path bpidFilePath = new Path(file.getParent(), filename);
        return new TextReader(fs, bpidFilePath, codec, delim);
    }

    @Override
    public BlockAliasMap.Writer<FileRegion> getWriter(BlockAliasMap.Writer.Options opts, String blockPoolID) throws IOException {
        if (null == opts) {
            opts = this.writerOpts;
        }
        if (!(opts instanceof WriterOptions)) {
            throw new IllegalArgumentException("Invalid options " + opts.getClass());
        }
        WriterOptions o = (WriterOptions)opts;
        Configuration cfg = null == o.getConf() ? new Configuration() : o.getConf();
        String baseName = TextFileRegionAliasMap.fileNameFromBlockPoolID(blockPoolID);
        Path blocksFile = new Path(o.dir, baseName);
        if (o.codec != null) {
            CompressionCodecFactory factory = new CompressionCodecFactory(cfg);
            CompressionCodec codec = factory.getCodecByName(o.codec);
            blocksFile = new Path(o.dir, baseName + codec.getDefaultExtension());
            return this.createWriter(blocksFile, codec, o.delim, cfg);
        }
        return this.createWriter(blocksFile, null, o.delim, this.conf);
    }

    @VisibleForTesting
    TextWriter createWriter(Path file, CompressionCodec codec, String delim, Configuration cfg) throws IOException {
        FileSystem fs = file.getFileSystem(cfg);
        if (fs instanceof LocalFileSystem) {
            fs = ((LocalFileSystem)fs).getRaw();
        }
        FSDataOutputStream tmp = fs.create(file);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)(null == codec ? tmp : codec.createOutputStream((OutputStream)tmp)), "UTF-8"));
        return new TextWriter(out, delim);
    }

    @Override
    public void refresh() throws IOException {
        throw new UnsupportedOperationException("Refresh not supported by " + this.getClass());
    }

    @Override
    public void close() throws IOException {
    }

    @VisibleForTesting
    public static String blockPoolIDFromFileName(Path file) {
        if (file == null) {
            return "";
        }
        String fileName = file.getName();
        return fileName.substring("blocks_".length()).split("\\.")[0];
    }

    @VisibleForTesting
    public static String fileNameFromBlockPoolID(String blockPoolID) {
        return "blocks_" + blockPoolID + ".csv";
    }

    public static class TextWriter
    extends BlockAliasMap.Writer<FileRegion> {
        private final String delim;
        private final Writer out;

        public static WriterOptions defaults() {
            return new WriterOptions();
        }

        public TextWriter(Writer out, String delim) {
            this.out = out;
            this.delim = delim;
        }

        @Override
        public void store(FileRegion token) throws IOException {
            Block block = token.getBlock();
            ProvidedStorageLocation psl = token.getProvidedStorageLocation();
            this.out.append(String.valueOf(block.getBlockId())).append(this.delim);
            this.out.append(psl.getPath().toString()).append(this.delim);
            this.out.append(Long.toString(psl.getOffset())).append(this.delim);
            this.out.append(Long.toString(psl.getLength())).append(this.delim);
            this.out.append(Long.toString(block.getGenerationStamp()));
            if (psl.getNonce().length > 0) {
                this.out.append(this.delim).append(Base64.getEncoder().encodeToString(psl.getNonce()));
            }
            this.out.append("\n");
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        public static interface Options
        extends BlockAliasMap.Writer.Options {
            public Options codec(String var1);

            public Options dirName(Path var1);

            public Options delimiter(String var1);
        }
    }

    public static class TextReader
    extends BlockAliasMap.Reader<FileRegion> {
        private final Path file;
        private final String delim;
        private final FileSystem fs;
        private final CompressionCodec codec;
        private final Map<FRIterator, BufferedReader> iterators;
        private final String blockPoolID;

        public static ReaderOptions defaults() {
            return new ReaderOptions();
        }

        protected TextReader(FileSystem fs, Path file, CompressionCodec codec, String delim) {
            this(fs, file, codec, delim, new IdentityHashMap<FRIterator, BufferedReader>());
        }

        TextReader(FileSystem fs, Path file, CompressionCodec codec, String delim, Map<FRIterator, BufferedReader> iterators) {
            this.fs = fs;
            this.file = file;
            this.codec = codec;
            this.delim = delim;
            this.iterators = Collections.synchronizedMap(iterators);
            this.blockPoolID = TextFileRegionAliasMap.blockPoolIDFromFileName(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<FileRegion> resolve(Block ident) throws IOException {
            Iterator<FileRegion> i = this.iterator();
            try {
                while (i.hasNext()) {
                    FileRegion f = i.next();
                    if (!f.getBlock().equals((Object)ident)) continue;
                    Optional<FileRegion> optional = Optional.of(f);
                    return optional;
                }
            }
            finally {
                BufferedReader r = this.iterators.remove(i);
                if (r != null) {
                    r.close();
                }
            }
            return Optional.empty();
        }

        private FileRegion nextInternal(Iterator<FileRegion> i) throws IOException {
            BufferedReader r = this.iterators.get(i);
            if (null == r) {
                throw new IllegalStateException();
            }
            String line = r.readLine();
            if (null == line) {
                this.iterators.remove(i);
                return null;
            }
            String[] f = line.split(this.delim);
            if (f.length != 5 && f.length != 6) {
                throw new IOException("Invalid line: " + line);
            }
            byte[] nonce = new byte[]{};
            if (f.length == 6) {
                nonce = Base64.getDecoder().decode(f[5]);
            }
            return new FileRegion(Long.parseLong(f[0]), new Path(f[1]), Long.parseLong(f[2]), Long.parseLong(f[3]), Long.parseLong(f[4]), nonce);
        }

        public InputStream createStream() throws IOException {
            FSDataInputStream i = this.fs.open(this.file);
            if (this.codec != null) {
                i = this.codec.createInputStream((InputStream)i);
            }
            return i;
        }

        @Override
        public Iterator<FileRegion> iterator() {
            FRIterator i = new FRIterator();
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(this.createStream(), "UTF-8"));
                this.iterators.put(i, r);
                i.pending = this.nextInternal(i);
            }
            catch (IOException e) {
                this.iterators.remove(i);
                throw new RuntimeException(e);
            }
            return i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            ArrayList<IOException> ex = new ArrayList<IOException>();
            Map<FRIterator, BufferedReader> map = this.iterators;
            synchronized (map) {
                Iterator<BufferedReader> i = this.iterators.values().iterator();
                while (i.hasNext()) {
                    try {
                        BufferedReader r = i.next();
                        r.close();
                    }
                    catch (IOException e) {
                        ex.add(e);
                    }
                    finally {
                        i.remove();
                    }
                }
                this.iterators.clear();
            }
            if (!ex.isEmpty()) {
                throw MultipleIOException.createIOException(ex);
            }
        }

        class FRIterator
        implements Iterator<FileRegion> {
            private FileRegion pending;

            FRIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.pending != null;
            }

            @Override
            public FileRegion next() {
                if (null == this.pending) {
                    throw new NoSuchElementException();
                }
                FileRegion ret = this.pending;
                try {
                    this.pending = TextReader.this.nextInternal(this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        public static interface Options
        extends BlockAliasMap.Reader.Options {
            public Options filename(Path var1);

            public Options delimiter(String var1);
        }
    }

    public static class WriterOptions
    implements TextWriter.Options,
    Configurable {
        private Configuration conf;
        private String codec = null;
        private Path dir = new Path("file:///tmp/");
        private String delim = ",";

        public void setConf(Configuration conf) {
            this.conf = conf;
            String tmpDir = conf.get("dfs.provided.aliasmap.text.write.dir", this.dir.toString());
            this.dir = new Path(tmpDir);
            this.codec = conf.get("dfs.provided.aliasmap.text.codec");
            this.delim = conf.get("dfs.provided.aliasmap.text.delimiter", ",");
        }

        public Configuration getConf() {
            return this.conf;
        }

        @Override
        public WriterOptions dirName(Path dir) {
            this.dir = dir;
            return this;
        }

        public String getCodec() {
            return this.codec;
        }

        public Path getDir() {
            return this.dir;
        }

        @Override
        public WriterOptions codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public WriterOptions delimiter(String delim) {
            this.delim = delim;
            return this;
        }
    }

    public static class ReaderOptions
    implements TextReader.Options,
    Configurable {
        private Configuration conf;
        private String delim = ",";
        private Path file = new Path(new File("file:///tmp/blocks.csv").toURI().toString());

        public void setConf(Configuration conf) {
            this.conf = conf;
            String tmpfile = conf.get("dfs.provided.aliasmap.text.read.file", "file:///tmp/blocks.csv");
            this.file = new Path(tmpfile);
            this.delim = conf.get("dfs.provided.aliasmap.text.delimiter", ",");
            LOG.info("TextFileRegionAliasMap: read path {}", (Object)tmpfile);
        }

        public Configuration getConf() {
            return this.conf;
        }

        @Override
        public ReaderOptions filename(Path file) {
            this.file = file;
            return this;
        }

        @Override
        public ReaderOptions delimiter(String delim) {
            this.delim = delim;
            return this;
        }
    }
}

