/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.models;

import java.time.LocalDateTime;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.CoordinatorConnectionModel;

public class TrafficModel
extends CoordinatorConnectionModel {
    private static final long serialVersionUID = 5042814368347405998L;
    public Long workerId;
    public LocalDateTime timestamp;
    public Long byteAmount;
    private static final String JsonFormat = "{\"timestamp\": \"%s\",\"coordinatorId\": %d,\"byteAmount\": %d}";

    public TrafficModel() {
    }

    public TrafficModel(LocalDateTime timestamp, String coordinatorHostId, Long byteAmount) {
        this.timestamp = timestamp;
        this.byteAmount = byteAmount;
        super.setCoordinatorHostId(coordinatorHostId);
    }

    public TrafficModel(Long workerId, String coordinatorAddress, Long byteAmount) {
        this(-1L, workerId, LocalDateTime.now(), coordinatorAddress, byteAmount);
    }

    public TrafficModel(Long id, Long workerId, LocalDateTime timestamp, String coordinatorHostId, Long byteAmount) {
        this.id = id;
        this.workerId = workerId;
        this.timestamp = timestamp;
        this.byteAmount = byteAmount;
        super.setCoordinatorHostId(coordinatorHostId);
    }

    public String toString() {
        return String.format(JsonFormat, this.timestamp, this.coordinatorId, this.byteAmount);
    }
}

