/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.util;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DateUtil {
    private static Log LOG = LogFactory.getLog(DateUtil.class);

    public static boolean verifyCreated(Date createdDate, int timeToLive, int futureTimeToLive) {
        if (createdDate == null) {
            return true;
        }
        Date validCreation = new Date();
        long currentTime = validCreation.getTime();
        if (futureTimeToLive > 0) {
            validCreation.setTime(currentTime + (long)futureTimeToLive * 1000L);
        }
        if (createdDate.after(validCreation)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Validation of Created: The message was created in the future!");
            }
            return false;
        }
        validCreation.setTime(currentTime -= (long)timeToLive * 1000L);
        if (createdDate.before(validCreation)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Validation of Created: The message was created too long ago");
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Validation of Created: Everything is ok");
        }
        return true;
    }
}

