/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform.url;

import java.net.URI;
import java.net.URISyntaxException;

public class URIFragments {
    public static final int FULL_URI = -2;
    public static final int PORT = -1;
    public static final int PROTOCOL = 0;
    public static final int USER_INFO = 1;
    public static final int HOST = 2;
    public static final int PATH = 3;
    public static final int QUERY = 4;
    public static final int REF = 5;
    private int port = -1;
    private String[] fragments = new String[6];

    public URIFragments() {
    }

    public URIFragments(URI uri) {
        this.setFragments(uri);
    }

    public void setFragments(URI uri) {
        this.fragments[0] = uri.getScheme();
        this.fragments[1] = uri.getUserInfo();
        this.fragments[2] = uri.getHost();
        this.fragments[3] = "".equals(uri.getPath()) ? null : uri.getPath();
        this.fragments[4] = uri.getQuery();
        this.fragments[5] = uri.getFragment();
        this.port = uri.getPort();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setStringFragment(int index, String value) {
        this.fragments[index] = value;
    }

    public String getStringFragment(int index) {
        return this.fragments[index];
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.fragments[0], this.fragments[1], this.fragments[2], this.port, this.fragments[3], this.fragments[4], this.fragments[5]);
    }

    public String toURIString() throws URISyntaxException {
        return this.toURI().toString();
    }
}

