/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.Properties;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.LoadBalanceMembershipHandler;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

public class Axis2LoadBalanceMembershipHandler
implements LoadBalanceMembershipHandler {
    private static final Log log = LogFactory.getLog(Axis2LoadBalanceMembershipHandler.class);
    private String lbDomain;
    private GroupManagementAgent groupMgtAgent;
    private ConfigurationContext configCtx;
    private LoadbalanceAlgorithm algorithm;
    private Properties properties;

    @Override
    public void init(Properties props, LoadbalanceAlgorithm algorithm) {
        this.properties = props;
        this.lbDomain = props.getProperty("applicationDomain");
        if (this.lbDomain == null) {
            String msg = "The applicationDomain property has not been specified in the dynamicLoadbalance configuration in the synapse.xml file. This has to be the same as the applicationDomain entry in the loadBalancer entry in the axis2.xml file.";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.algorithm = algorithm;
    }

    @Override
    public void setConfigurationContext(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        ClusteringAgent clusteringAgent = configCtx.getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent == null) {
            String msg = "In order to enable load balancing across an Axis2 cluster, the cluster entry should be enabled in the axis2.xml file";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.groupMgtAgent = clusteringAgent.getGroupManagementAgent(this.lbDomain);
        if (this.groupMgtAgent == null) {
            String msg = "A LoadBalanceEventHandler has not been specified in the axis2.xml file for the domain " + this.lbDomain;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
    }

    @Override
    public ConfigurationContext getConfigurationContext() {
        return this.configCtx;
    }

    @Override
    public Member getNextApplicationMember(AlgorithmContext context) {
        this.algorithm.setApplicationMembers(this.groupMgtAgent.getMembers());
        return this.algorithm.getNextApplicationMember(context);
    }

    @Override
    public LoadbalanceAlgorithm getLoadbalanceAlgorithm() {
        return this.algorithm;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }
}

