/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.SourceResponse;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;

public class SourceResponseFactory {
    public static SourceResponse create(MessageContext msgContext, SourceRequest sourceRequest, SourceConfiguration sourceConfiguration) {
        int statusCode = PassThroughTransportUtils.determineHttpStatusCode(msgContext);
        SourceResponse sourceResponse = new SourceResponse(sourceConfiguration, statusCode, sourceRequest);
        HashMap<String, String> transportHeaders = (HashMap<String, String>)msgContext.getProperty("TRANSPORT_HEADERS");
        if (msgContext.isPropertyTrue("FORCE_HTTP_CONTENT_LENGTH") && msgContext.isPropertyTrue("COPY_CONTENT_LENGTH_FROM_INCOMING") && msgContext.getProperty("ORIGINAL_CONTENT_LENGTH") != null) {
            sourceResponse.addHeader("Content-Length", (String)msgContext.getProperty("ORIGINAL_CONTENT_LENGTH"));
        }
        if (transportHeaders != null) {
            SourceResponseFactory.addResponseHeader(sourceResponse, transportHeaders);
        } else {
            Boolean noEntityBody = (Boolean)msgContext.getProperty("NO_ENTITY_BODY");
            if (noEntityBody == null || Boolean.FALSE == noEntityBody) {
                OMOutputFormat format = NhttpUtil.getOMOutputFormat(msgContext);
                transportHeaders = new HashMap<String, String>();
                MessageFormatter messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
                transportHeaders.put("Content-Type", messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction()));
                SourceResponseFactory.addResponseHeader(sourceResponse, transportHeaders);
            }
        }
        String excessProp = "EXCESS_TRANSPORT_HEADERS";
        Map excessHeaders = (Map)msgContext.getProperty(excessProp);
        if (excessHeaders != null) {
            for (String key : excessHeaders.keySet()) {
                for (String excessVal : (Collection)excessHeaders.get(key)) {
                    sourceResponse.addHeader(key, excessVal);
                }
            }
        }
        return sourceResponse;
    }

    private static void addResponseHeader(SourceResponse sourceResponse, Map transportHeaders) {
        for (Map.Entry entryObj : transportHeaders.entrySet()) {
            Map.Entry entry = entryObj;
            if (entry.getValue() == null || !(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            sourceResponse.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

