/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.kickstart.run;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.sling.maven.kickstart.run.AbstractStartStopMojo;
import org.apache.sling.maven.kickstart.run.LauncherCallable;
import org.apache.sling.maven.kickstart.run.ProcessDescription;
import org.apache.sling.maven.kickstart.run.ProcessDescriptionProvider;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public class StopMojo
extends AbstractStartStopMojo {
    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Properties kickstartConfigProps = new Properties();
        FileReader reader = null;
        try {
            reader = new FileReader(this.systemPropertiesFile);
            kickstartConfigProps.load(reader);
        }
        catch (IOException ioe) {
            try {
                throw new MojoExecutionException("Unable to read kickstart runner configuration properties.", (Exception)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        int instances = Integer.valueOf(kickstartConfigProps.getProperty("kickstart.instances"));
        ArrayList<ProcessDescription> configurations = new ArrayList<ProcessDescription>();
        for (int i = 1; i <= instances; ++i) {
            String id = kickstartConfigProps.getProperty("kickstart.instance.id." + String.valueOf(i));
            ProcessDescription config = ProcessDescriptionProvider.getInstance().getRunConfiguration(id);
            if (config == null) {
                this.getLog().warn((CharSequence)("No kickstart configuration found for instance " + id));
                continue;
            }
            configurations.add(config);
        }
        this.blockIfNecessary();
        if (configurations.size() > 0) {
            this.getLog().info((CharSequence)("Stopping " + configurations.size() + " Kickstart instances"));
            for (ProcessDescription cfg : configurations) {
                try {
                    LauncherCallable.stop(this.getLog(), cfg);
                    ProcessDescriptionProvider.getInstance().removeRunConfiguration(cfg.getId());
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Could not stop kickstart " + cfg.getId(), e);
                }
            }
        } else {
            this.getLog().warn((CharSequence)("No stored configuration file was found at " + this.systemPropertiesFile + " - no Launchapd will be stopped"));
        }
    }
}

