/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.access.models;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.jackrabbit.accessmanager.GetAce;
import org.apache.sling.jcr.jackrabbit.accessmanager.GetAcl;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.starter.access.models.AccessFormPage;
import org.apache.sling.starter.access.models.AceUtils;
import org.apache.sling.starter.access.models.PrincipalPrivilege;
import org.apache.sling.starter.access.models.PrivilegeItem;
import org.apache.sling.starter.access.models.RestrictionDefinitionInfo;
import org.apache.sling.starter.access.models.RestrictionItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingJakartaHttpServletRequest.class})
public class Ace
extends AccessFormPage {
    protected static final String PATH_REPOSITORY = "/:repository";
    protected static final Pattern RESTRICTION_PATTERN = Pattern.compile("^restriction@([^@]+)@([^@]+)@(Allow|Deny)$");
    protected static final Pattern RESTRICTION_PATTERN_DELETE = Pattern.compile(String.format("^restriction@([^@]+)@([^@]+)%s$", "@Delete"));
    protected static final Map<String, Integer> privilegesPriority = Ace.createPrivilegesPriorityMap();
    protected String principalId;
    protected Map<Privilege, PrivilegeItem> persistedPrivilegesMap = null;
    private boolean aceExists;
    @OSGiService
    protected List<RestrictionProvider> restrictionProviders = null;
    @OSGiService
    public GetAce getAce = null;
    @OSGiService
    public GetAcl getAcl = null;

    protected static Map<String, Integer> createPrivilegesPriorityMap() {
        HashMap<String, Integer> myMap = new HashMap<String, Integer>();
        myMap.put("jcr:read", 1);
        myMap.put("rep:write", 2);
        myMap.put("jcr:readAccessControl", 3);
        myMap.put("jcr:modifyAccessControl", 4);
        myMap.put("jcr:write", 1);
        myMap.put("jcr:nodeTypeManagement", 2);
        return myMap;
    }

    @Override
    @PostConstruct
    protected void init() throws IOException {
        super.init();
        this.principalId = this.request.getParameter("pid");
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public boolean getIsInvalidPrincipal() throws RepositoryException {
        Authorizable authorizable;
        JackrabbitSession jackrabbitSession;
        UserManager userManager;
        Session session;
        boolean isInValidPrincipal = true;
        if (this.principalId != null && !this.principalId.isEmpty() && (session = (Session)this.request.getResourceResolver().adaptTo(Session.class)) instanceof JackrabbitSession && (userManager = (jackrabbitSession = (JackrabbitSession)session).getUserManager()) != null && (authorizable = userManager.getAuthorizable(this.principalId)) != null) {
            isInValidPrincipal = false;
        }
        return isInValidPrincipal;
    }

    protected String getAcePath() {
        return this.resource.getPath();
    }

    public boolean isExists() {
        return this.aceExists;
    }

    public Collection<PrivilegeItem> getPrivileges() throws RepositoryException {
        Map<Privilege, PrivilegeItem> privilegesMap = this.getPersistedPrivilegesMap();
        if (privilegesMap == null || privilegesMap.isEmpty()) {
            return Collections.emptyList();
        }
        Set<RestrictionDefinition> supportedRestrictions = this.getSupportedRestrictions();
        Map<String, RestrictionDefinition> srMap = this.toSrMap(supportedRestrictions);
        HashMap<String, List<RestrictionItem>> postedAllowRestrictionsMap = new HashMap<String, List<RestrictionItem>>();
        HashMap<String, List<RestrictionItem>> postedDenyRestrictionsMap = new HashMap<String, List<RestrictionItem>>();
        Map<String, String[]> fieldValues = this.populateEntriesFromPreviousFailedPost(postedAllowRestrictionsMap, postedDenyRestrictionsMap, srMap);
        Map<String, String[]> toDeleteFieldValues = this.getFieldValuesForPattern(RESTRICTION_PATTERN_DELETE);
        for (PrivilegeItem entry : privilegesMap.values()) {
            String privilegeName = entry.getName();
            String paramValue = this.request.getParameter(String.format("privilege@%s", privilegeName));
            if (paramValue != null) {
                if ("granted".equals(paramValue)) {
                    entry.setGranted(true);
                } else if ("denied".equals(paramValue)) {
                    entry.setDenied(true);
                }
            } else {
                String paramDeleteValue = this.request.getParameter(String.format("privilege@%s@Delete", privilegeName));
                if (paramDeleteValue != null) {
                    if ("granted".equals(paramDeleteValue)) {
                        entry.setGranted(false);
                    } else if ("denied".equals(paramDeleteValue)) {
                        entry.setDenied(false);
                    }
                }
            }
            for (Object forAllow : (String)new boolean[]{true, false}) {
                List<RestrictionItem> declaredRestrictions;
                HashMap<String, List<RestrictionItem>> postedRestrictionsMap = forAllow != false ? postedAllowRestrictionsMap : postedDenyRestrictionsMap;
                List newRestrictionsList = postedRestrictionsMap.computeIfAbsent(privilegeName, pn -> new ArrayList());
                List<RestrictionItem> list2 = declaredRestrictions = forAllow != false ? entry.getAllowRestrictions() : entry.getDenyRestrictions();
                if (declaredRestrictions != null && !declaredRestrictions.isEmpty()) {
                    for (RestrictionItem ri : declaredRestrictions) {
                        String restrictionName = ri.getName();
                        boolean addIt = true;
                        String fieldKeyPrefix = String.format("restriction@%s@%s", privilegeName, restrictionName);
                        String fieldKey = String.format("%s@%s", fieldKeyPrefix, forAllow != false ? "Allow" : "Deny");
                        if (toDeleteFieldValues.containsKey(String.format("%s%s", fieldKeyPrefix, "@Delete"))) {
                            addIt = false;
                        } else if (fieldValues.containsKey(fieldKey)) {
                            newRestrictionsList.stream().filter(list -> list.getName().equals(restrictionName)).forEach(item -> item.setExists(true));
                            addIt = false;
                        }
                        if (!addIt) continue;
                        newRestrictionsList.add(ri);
                    }
                }
                this.populateEntriesForMissingMandatoryRestrictions(newRestrictionsList, supportedRestrictions);
                if (forAllow != false) {
                    entry.setAllowRestrictions(newRestrictionsList);
                } else {
                    entry.setDenyRestrictions(newRestrictionsList);
                }
                toDeleteFieldValues.keySet().stream().filter(key -> RESTRICTION_PATTERN_DELETE.matcher((CharSequence)key).matches()).forEach(arg_0 -> Ace.lambda$getPrivileges$4((boolean)forAllow, entry, arg_0));
            }
        }
        ArrayList<PrivilegeItem> list3 = new ArrayList<PrivilegeItem>(privilegesMap.values());
        list3.sort((p1, p2) -> {
            String longestPath1 = p1.getLongestPath();
            String[] segments1 = longestPath1.split("/");
            String longestPath2 = p2.getLongestPath();
            String[] segments2 = longestPath2.split("/");
            for (int i = 0; i < segments1.length; ++i) {
                Integer priority1 = privilegesPriority.getOrDefault(segments1[i], 1000);
                if (segments2.length <= i) {
                    return longestPath1.compareTo(longestPath2);
                }
                Integer priority2 = privilegesPriority.getOrDefault(segments2[i], 1000);
                int cmp = priority1.compareTo(priority2);
                if (cmp == 0) continue;
                return cmp;
            }
            if (segments1.length == segments2.length) {
                String lastSegment1 = segments1[segments1.length - 1];
                String lastSegment2 = segments2[segments2.length - 1];
                lastSegment1 = lastSegment1.substring(lastSegment1.indexOf(58));
                lastSegment2 = lastSegment2.substring(lastSegment2.indexOf(58));
                return lastSegment1.compareTo(lastSegment2);
            }
            return longestPath1.compareTo(longestPath2);
        });
        boolean lastBranch = true;
        for (int i = list3.size() - 1; i > 0; --i) {
            PrivilegeItem item2 = (PrivilegeItem)list3.get(i);
            if (lastBranch) {
                item2.addExtraCssClass("lastBranch");
            }
            if (lastBranch && item2.getDepth() == 1L) {
                lastBranch = false;
            }
            if (i == list3.size() - 1) {
                item2.addExtraCssClass("lastSibling");
                continue;
            }
            boolean lastSibling = true;
            for (int j = i + 1; j < list3.size(); ++j) {
                PrivilegeItem nextItem = (PrivilegeItem)list3.get(j);
                if (nextItem.getDepth() != item2.getDepth()) continue;
                String nextItemParentPath = ResourceUtil.getParent((String)nextItem.getLongestPath());
                String itemParentPath = ResourceUtil.getParent((String)item2.getLongestPath());
                if (nextItemParentPath == null || !nextItemParentPath.equals(itemParentPath)) continue;
                lastSibling = false;
                break;
            }
            if (!lastSibling) continue;
            item2.addExtraCssClass("lastSibling");
        }
        return list3;
    }

    protected Map<String, String[]> populateEntriesFromPreviousFailedPost(Map<String, List<RestrictionItem>> allowMap, Map<String, List<RestrictionItem>> denyMap, Map<String, RestrictionDefinition> srMap) {
        Map<String, String[]> toDeleteFieldValues = this.getFieldValuesForPattern(RESTRICTION_PATTERN_DELETE);
        Map<String, String[]> fieldValues = this.getFieldValuesForPattern(RESTRICTION_PATTERN);
        Set<Map.Entry<String, String[]>> fieldValuesEntrySet = fieldValues.entrySet();
        for (Map.Entry<String, String[]> entry : fieldValuesEntrySet) {
            Matcher matcher;
            String deleteKey = String.format("%s%s", entry.getKey(), "@Delete");
            if (toDeleteFieldValues.containsKey(deleteKey) || !(matcher = RESTRICTION_PATTERN.matcher(entry.getKey())).matches()) continue;
            String privilegeName = matcher.group(1);
            String restrictionName = matcher.group(2);
            boolean isAllow = "Allow".equals(matcher.group(3));
            RestrictionDefinition rd = srMap.get(restrictionName);
            if (rd == null) continue;
            Object value = entry.getValue();
            String[] strings = entry.getValue();
            if (rd.getRequiredType().isArray()) {
                value = strings;
            } else if (strings.length > 0) {
                value = strings[0];
            }
            RestrictionItem ri = new RestrictionItem(rd, value, false);
            Map<String, List<RestrictionItem>> map = isAllow ? allowMap : denyMap;
            List list = map.computeIfAbsent(privilegeName, n -> new ArrayList());
            list.add(ri);
        }
        return fieldValues;
    }

    protected void populateEntriesForMissingMandatoryRestrictions(List<RestrictionItem> list, Set<RestrictionDefinition> supportedRestrictions) {
        if (supportedRestrictions != null) {
            for (RestrictionDefinition rd : supportedRestrictions) {
                if (!rd.isMandatory() || !list.stream().noneMatch(item -> item.getName().equals(rd.getName()))) continue;
                RestrictionItem ri = new RestrictionItem(rd, null, false);
                list.add(ri);
            }
        }
    }

    protected Map<String, RestrictionDefinition> toSrMap(Set<RestrictionDefinition> supportedRestrictions) {
        HashMap<String, RestrictionDefinition> srMap = new HashMap<String, RestrictionDefinition>();
        for (RestrictionDefinition restrictionDefinition : supportedRestrictions) {
            srMap.put(restrictionDefinition.getName(), restrictionDefinition);
        }
        return srMap;
    }

    @NotNull
    protected Privilege[] getSupportedOrRegisteredPrivileges(@NotNull Session jcrSession, @Nullable String resourcePath) throws RepositoryException {
        Privilege[] supportedPrivileges = null;
        if (resourcePath != null && jcrSession.nodeExists(resourcePath)) {
            supportedPrivileges = jcrSession.getAccessControlManager().getSupportedPrivileges(resourcePath);
        } else {
            Workspace workspace = jcrSession.getWorkspace();
            if (workspace instanceof JackrabbitWorkspace) {
                JackrabbitWorkspace jackrabbitWorkspace = (JackrabbitWorkspace)workspace;
                PrivilegeManager privilegeManager = jackrabbitWorkspace.getPrivilegeManager();
                supportedPrivileges = privilegeManager.getRegisteredPrivileges();
            }
        }
        return supportedPrivileges == null ? new Privilege[]{} : supportedPrivileges;
    }

    protected Map<Privilege, PrivilegeItem> initialPrivilegesMap(Map<Privilege, String> privilegeToLongestPath, String acePath) {
        HashMap<Privilege, PrivilegeItem> newMap = new HashMap<Privilege, PrivilegeItem>();
        Privilege[] supportedPrivileges = null;
        try {
            Session jcrSession = (Session)this.request.getResourceResolver().adaptTo(Session.class);
            supportedPrivileges = this.getSupportedOrRegisteredPrivileges(jcrSession, PATH_REPOSITORY.equals(acePath) ? null : acePath);
        }
        catch (RepositoryException e) {
            supportedPrivileges = null;
        }
        if (supportedPrivileges != null) {
            for (Privilege privilege : supportedPrivileges) {
                PrivilegeItem p1 = new PrivilegeItem(privilege.getName(), false, false, privilegeToLongestPath.get(privilege));
                newMap.put(privilege, p1);
            }
        }
        return newMap;
    }

    protected Map<Privilege, PrivilegeItem> getPersistedPrivilegesMap() throws RepositoryException {
        if (this.persistedPrivilegesMap == null) {
            JsonObject ace;
            Session jcrSession = (Session)this.request.getResourceResolver().adaptTo(Session.class);
            Map<Privilege, String> privilegeToLongestPath = AceUtils.getPrivilegeLongestPathMap(jcrSession);
            String acePath = this.getAcePath();
            this.persistedPrivilegesMap = this.initialPrivilegesMap(privilegeToLongestPath, acePath);
            try {
                ace = this.getAce.getAce(jcrSession, acePath, this.getPrincipalId());
            }
            catch (ResourceNotFoundException rnfe) {
                ace = null;
            }
            if (ace != null) {
                this.aceExists = true;
                AccessControlManager acm = jcrSession.getAccessControlManager();
                Set<RestrictionDefinition> supportedRestrictions = this.getSupportedRestrictions();
                Map<String, RestrictionDefinition> srMap = this.toSrMap(supportedRestrictions);
                JsonObject privileges = ace.getJsonObject("privileges");
                for (String pn : privileges.keySet()) {
                    JsonValue denyJsonValue;
                    Privilege p = acm.privilegeFromName(pn);
                    PrivilegeItem privilegeItem = this.persistedPrivilegesMap.computeIfAbsent(p, key -> new PrivilegeItem(key.getName(), false, false, (String)privilegeToLongestPath.get(key)));
                    JsonObject privilegeObj = privileges.getJsonObject(pn);
                    JsonValue allowJsonValue = (JsonValue)privilegeObj.get((Object)"allow");
                    if (allowJsonValue != null) {
                        privilegeItem.setAllowExists(true);
                        privilegeItem.setGranted(true);
                        if (allowJsonValue instanceof JsonObject) {
                            JsonObject jsonObject = (JsonObject)allowJsonValue;
                            List<RestrictionItem> restrictionItems = this.jsonToRestrictionItems(srMap, jsonObject);
                            privilegeItem.setAllowRestrictions(restrictionItems);
                        }
                    }
                    if ((denyJsonValue = (JsonValue)privilegeObj.get((Object)"deny")) == null) continue;
                    privilegeItem.setDenyExists(true);
                    privilegeItem.setDenied(true);
                    if (!(denyJsonValue instanceof JsonObject)) continue;
                    JsonObject jsonObject = (JsonObject)denyJsonValue;
                    List<RestrictionItem> restrictionItems = this.jsonToRestrictionItems(srMap, jsonObject);
                    privilegeItem.setDenyRestrictions(restrictionItems);
                }
            }
        }
        return this.persistedPrivilegesMap;
    }

    protected List<RestrictionItem> jsonToRestrictionItems(Map<String, RestrictionDefinition> srMap, JsonObject restrictionsObj) {
        ArrayList<RestrictionItem> restrictionItems = new ArrayList<RestrictionItem>();
        for (Map.Entry entry : restrictionsObj.entrySet()) {
            String rn = (String)entry.getKey();
            RestrictionDefinition rd = srMap.get(rn);
            if (rd == null) continue;
            String[] value = null;
            JsonValue jsonValue = (JsonValue)entry.getValue();
            if (jsonValue instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonValue;
                String[] values = new String[jsonArray.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = jsonArray.getString(i);
                }
                value = values;
            } else if (jsonValue instanceof JsonString) {
                JsonString jsonString = (JsonString)jsonValue;
                value = jsonString.getString();
            }
            restrictionItems.add(new RestrictionItem(rd, value, true));
        }
        return restrictionItems;
    }

    public Set<RestrictionDefinition> getSupportedRestrictions() {
        HashSet<RestrictionDefinition> supportedRestrictions = new HashSet<RestrictionDefinition>();
        for (RestrictionProvider rp : this.restrictionProviders) {
            supportedRestrictions.addAll(rp.getSupportedRestrictions(this.resource.getPath()));
        }
        return supportedRestrictions;
    }

    public List<RestrictionDefinitionInfo> getSupportedRestrictionsInfo() {
        return this.getSupportedRestrictions().stream().map(rd -> new RestrictionDefinitionInfo(rd.getName(), (RestrictionDefinition)rd)).sorted(Comparator.comparing(RestrictionDefinitionInfo::getDisplayName)).toList();
    }

    public String getPrivilegeAggregationsAsJSON() throws RepositoryException {
        Privilege[] supported;
        JsonBuilderFactory factory = Json.createBuilderFactory(Collections.emptyMap());
        JsonObjectBuilder builder = factory.createObjectBuilder();
        Session jcrSession = (Session)this.request.getResourceResolver().adaptTo(Session.class);
        Map<Privilege, String> privilegeToLongestPath = AceUtils.getPrivilegeLongestPathMap(jcrSession);
        for (Privilege privilege : supported = this.getSupportedOrRegisteredPrivileges(jcrSession, this.resource.getPath())) {
            Privilege[] aggregatePrivileges = privilege.getAggregatePrivileges();
            if (aggregatePrivileges == null || aggregatePrivileges.length <= 0) continue;
            ArrayList<Privilege> list = new ArrayList<Privilege>(Arrays.asList(aggregatePrivileges));
            list.sort((o1, o2) -> ((String)privilegeToLongestPath.get(o1)).compareTo((String)privilegeToLongestPath.get(o2)));
            JsonArrayBuilder aggregateArray = factory.createArrayBuilder();
            for (Privilege privilege2 : list) {
                aggregateArray.add(privilege2.getName());
            }
            builder.add(privilege.getName(), aggregateArray);
        }
        JsonObject jsonObj = builder.build();
        return jsonObj.toString();
    }

    public String getExistingRestrictionNamesAsJSON() throws RepositoryException {
        JsonObjectBuilder jsonObjBuilder = Json.createObjectBuilder();
        for (boolean forAllow : new boolean[]{true, false}) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            HashSet<String> alreadyProcessed = new HashSet<String>();
            for (PrivilegeItem pi : this.getPrivileges()) {
                if ((!forAllow || !pi.getGranted()) && (forAllow || !pi.getDenied())) continue;
                List<RestrictionItem> restrictions = forAllow ? pi.getAllowRestrictions() : pi.getDenyRestrictions();
                for (RestrictionItem ri : restrictions) {
                    String name;
                    if (!ri.isExists() || alreadyProcessed.contains(name = String.format("%s@%s", pi.getName(), ri.getName()))) continue;
                    jsonArrayBuilder.add(name);
                    alreadyProcessed.add(name);
                }
            }
            jsonObjBuilder.add(forAllow ? "allow" : "deny", jsonArrayBuilder);
        }
        return jsonObjBuilder.build().toString();
    }

    public String getOrderValue() {
        String parameter = this.request.getParameter("order");
        return parameter == null ? "" : parameter;
    }

    public Collection<PrincipalPrivilege> getOrderList() throws RepositoryException {
        ArrayList<PrincipalPrivilege> list = new ArrayList<PrincipalPrivilege>();
        Session jcrSession = (Session)this.request.getResourceResolver().adaptTo(Session.class);
        PrincipalManager principalManager = ((JackrabbitSession)jcrSession).getPrincipalManager();
        String pid = this.getPrincipalId();
        JsonObject acl = this.getAcl.getAcl(jcrSession, this.getAcePath());
        for (String uid : acl.keySet()) {
            Principal principal;
            if (pid != null && pid.equals(uid) || (principal = principalManager.getPrincipal(uid)) == null) continue;
            PrincipalPrivilege pi = new PrincipalPrivilege(principal);
            list.add(pi);
        }
        return list;
    }

    protected String[] fieldValuesFromReqParams(RequestParameter[] paramValues) {
        String[] fieldValues = null;
        fieldValues = new String[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            fieldValues[i] = paramValues[i].getString();
        }
        return fieldValues;
    }

    protected Map<String, String[]> getFieldValuesForPattern(Pattern keyPattern) {
        HashMap<String, String[]> resultMap = new HashMap<String, String[]>();
        @NotNull RequestParameterMap requestParameterMap = this.request.getRequestParameterMap();
        Set entrySet2 = requestParameterMap.entrySet();
        for (Map.Entry entry : entrySet2) {
            RequestParameter[] paramValues;
            Matcher matcher;
            String key2 = (String)entry.getKey();
            if (resultMap.containsKey(key2) || !(matcher = keyPattern.matcher(key2)).matches() || (paramValues = (RequestParameter[])entry.getValue()) == null) continue;
            String[] fieldValues = this.fieldValuesFromReqParams(paramValues);
            resultMap.put(key2, fieldValues);
        }
        return resultMap;
    }

    private static /* synthetic */ void lambda$getPrivileges$4(boolean forAllow, PrivilegeItem entry, String key) {
        Matcher matcher = RESTRICTION_PATTERN_DELETE.matcher(key);
        if (matcher.matches()) {
            String restrictionName = matcher.group(2);
            if (forAllow) {
                entry.addAllowRestrictionToDelete(restrictionName);
            } else {
                entry.addDenyRestrictionToDelete(restrictionName);
            }
        }
    }
}

