/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingJakartaSafeMethodsServlet;
import org.apache.sling.servlets.get.impl.helpers.HeadServletResponse;
import org.apache.sling.servlets.get.impl.helpers.HtmlRenderer;
import org.apache.sling.servlets.get.impl.helpers.JsonRenderer;
import org.apache.sling.servlets.get.impl.helpers.PlainTextRenderer;
import org.apache.sling.servlets.get.impl.helpers.Renderer;
import org.apache.sling.servlets.get.impl.helpers.StreamRenderer;
import org.apache.sling.servlets.get.impl.helpers.XMLRenderer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, name="org.apache.sling.servlets.get.DefaultGetServlet", property={"service.description=Default GET Servlet", "service.vendor=The Apache Software Foundation", "sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.prefix:Integer=-1", "sling.servlet.methods=GET", "sling.servlet.methods=HEAD"})
@Designate(ocd=Config.class)
public class DefaultGetServlet
extends SlingJakartaSafeMethodsServlet {
    private static final long serialVersionUID = -2714152339750885354L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, Renderer> rendererMap = new HashMap<String, Renderer>();
    private int jsonMaximumResults;
    private String[] aliases;
    private boolean index;
    private String[] indexFiles;
    private boolean enableHtml;
    private boolean enableTxt;
    private boolean enableJson;
    private boolean enableXml;
    private boolean enableEcmaSupport;
    public static final String EXT_HTML = "html";
    public static final String EXT_TXT = "txt";
    public static final String EXT_JSON = "json";
    public static final String EXT_XML = "xml";
    public static final String EXT_RES = "res";

    @Activate
    protected void activate(Config cfg) {
        this.aliases = cfg.aliases();
        this.index = cfg.index();
        this.indexFiles = cfg.index_files();
        if (this.indexFiles == null) {
            this.indexFiles = new String[0];
        }
        this.enableHtml = cfg.enable_html();
        this.enableTxt = cfg.enable_txt();
        this.enableJson = cfg.enable_json();
        this.enableXml = cfg.enable_xml();
        this.jsonMaximumResults = cfg.json_maximumresults();
        this.enableEcmaSupport = cfg.ecmaSuport();
        if (this.enableEcmaSupport) {
            this.logger.info("Legacy ECMA format is enabled");
        }
    }

    @Deactivate
    protected void deactivate() {
        this.aliases = null;
        this.index = false;
        this.indexFiles = null;
    }

    private Renderer getDefaultRenderer(String type) {
        Renderer renderer = null;
        if (EXT_RES.equals(type)) {
            renderer = new StreamRenderer(this.index, this.indexFiles, this.getServletContext());
        } else if (EXT_HTML.equals(type)) {
            renderer = HtmlRenderer.INSTANCE;
        } else if (EXT_TXT.equals(type)) {
            renderer = new PlainTextRenderer();
        } else if (EXT_JSON.equals(type)) {
            renderer = new JsonRenderer(this.jsonMaximumResults, this.enableEcmaSupport);
        } else if (EXT_XML.equals(type)) {
            renderer = new XMLRenderer();
        }
        return renderer;
    }

    public void init() throws ServletException {
        super.init();
        Renderer streamRenderer = this.getDefaultRenderer(EXT_RES);
        this.rendererMap.put(null, streamRenderer);
        this.rendererMap.put(EXT_RES, streamRenderer);
        if (this.enableHtml) {
            this.rendererMap.put(EXT_HTML, this.getDefaultRenderer(EXT_HTML));
        }
        if (this.enableTxt) {
            this.rendererMap.put(EXT_TXT, this.getDefaultRenderer(EXT_TXT));
        }
        if (this.enableJson) {
            this.rendererMap.put(EXT_JSON, this.getDefaultRenderer(EXT_JSON));
        }
        if (this.enableXml) {
            this.rendererMap.put(EXT_XML, this.getDefaultRenderer(EXT_XML));
        }
        if (this.aliases != null) {
            for (String m : this.aliases) {
                int pos = m.indexOf(58);
                if (pos == -1) continue;
                String type = m.substring(0, pos);
                Renderer renderer = this.rendererMap.get(type);
                if (renderer == null) {
                    renderer = this.getDefaultRenderer(type);
                }
                if (renderer != null) {
                    String extensions = m.substring(pos + 1);
                    StringTokenizer st = new StringTokenizer(extensions, ",");
                    while (st.hasMoreTokens()) {
                        String ext = st.nextToken();
                        this.rendererMap.put(ext, renderer);
                    }
                    continue;
                }
                this.logger.warn("Unable to enable renderer alias(es) for {} - type not supported", (Object)m);
            }
        }
    }

    protected void doGet(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws ServletException, IOException {
        if (ResourceUtil.isNonExistingResource((Resource)request.getResource())) {
            throw new ResourceNotFoundException(request.getResource().getPath(), "No resource found");
        }
        String ext = request.getRequestPathInfo().getExtension();
        Renderer renderer = this.rendererMap.get(ext);
        if (renderer == null) {
            request.getRequestProgressTracker().log("No renderer for extension " + ext);
            if (response.isCommitted() || request.getAttribute("org.apache.sling.api.include.jakarta.servlet") != null) {
                this.logger.error("No renderer for extension {}, cannot render resource {}", (Object)ext, (Object)request.getResource());
            } else {
                response.sendError(404);
            }
            return;
        }
        request.getRequestProgressTracker().log("Using " + renderer.getClass().getName() + " to render for extension=" + ext);
        renderer.render(request, response);
    }

    protected void doHead(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws ServletException, IOException {
        response = new HeadServletResponse((SlingJakartaHttpServletResponse)response);
        this.doGet(request, (SlingJakartaHttpServletResponse)response);
    }

    public void destroy() {
        this.rendererMap.clear();
        super.destroy();
    }

    @ObjectClassDefinition(name="Apache Sling GET Servlet", description="The Sling GET servlet is registered as the default servlet to handle GET requests.")
    public static @interface Config {
        @AttributeDefinition(name="Extension Aliases", description="The aliases can be used to map several extensions to a single servlet. This works irrespective if the renderer for the target extension is enabled or not. For instance \"xml:pdf,rtf\" maps the extensions \".pdf\" and \".rtf\" to the servlet helper handling the \".xml\" extension.")
        public String[] aliases();

        @AttributeDefinition(name="Auto Index", description="Controls whether a simple directory index is rendered for a directory request. A directory request is a request to a resource with a trailing slash (/) character, for example http://host/apps/. If none of the index resources exists, the default GET servlet may automatically render an index listing of the child resources if this option is checked, which is the default. If this option is not checked, the request to the resource is forbidden and results in a status 403/FORBIDDEN. This configuration corresponds to the \"Index\" option of the Options directive of Apache HTTP Server (httpd).")
        public boolean index() default false;

        @AttributeDefinition(name="Index Resources", description="List of child resources to be considered for rendering  the index of a \"directory\". The default value is [ \"index\", \"index.html\" ].  Each entry in the list is checked and the first entry found is included to  render the index. If an entry is selected, which has not extension (for  example the \"index\" resource), the extension \".html\" is appended for the  inclusion to indicate the desired text/html rendering. If the resource name  has an extension (as in \"index.html\"), no additional extension is appended  for the inclusion. This configuration corresponds to the <DirectoryIndex>  directive of Apache HTTP Server (httpd).")
        public String[] index_files() default {"index", "index.html"};

        @AttributeDefinition(name="Enable HTML", description="Whether the renderer for HTML of the default GET servlet is enabled for extension \"html\" or not.")
        public boolean enable_html() default true;

        @AttributeDefinition(name="Enable JSON", description="Whether the renderer for JSON of the default GET servlet is enabled for extension \"json\" or not.")
        public boolean enable_json() default true;

        @AttributeDefinition(name="Enable Plain Text", description="Whether the renderer for plain text of the default GET servlet is enabled for extension \"txt\" or not.")
        public boolean enable_txt() default true;

        @AttributeDefinition(name="Enable XML", description="Whether the renderer for XML of the default GET servlet is enabled for extension \"xml\" or not.")
        public boolean enable_xml() default true;

        @AttributeDefinition(name="JSON Max results", description="The maximum number of resources that should be returned when doing a node.5.json or node.infinity.json. In JSON terms this basically means the number of Objects to return. Default value is 200.")
        public int json_maximumresults() default 200;

        @AttributeDefinition(name="Legacy ECMA date format", description="Enable legacy Sling ECMA format for dates")
        public boolean ecmaSuport() default true;
    }
}

