/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.junit.RendererSelector;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.TestsManager;
import org.apache.sling.junit.impl.servlet.ServletProcessor;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"sling/junit/testing"}, extensions={"junit"}, methods={"GET", "POST"})
public class SlingJUnitServlet
extends HttpServlet {
    public static final String EXTENSION = ".junit";
    @Reference
    private TestsManager testsManager;
    @Reference
    private RendererSelector rendererSelector;
    private volatile ServletProcessor processor;

    @Activate
    protected void activate(ComponentContext ctx) {
        this.processor = new ServletProcessor(this.testsManager, this.rendererSelector){

            @Override
            protected String getTestSelectionPath(HttpServletRequest request) {
                String result = request.getPathInfo();
                int pos = result.indexOf(SlingJUnitServlet.EXTENSION);
                if (pos >= 0) {
                    result = result.substring(pos + SlingJUnitServlet.EXTENSION.length());
                }
                return result;
            }

            @Override
            protected String getTestExecutionPath(HttpServletRequest request, TestSelector selector, String extension) {
                String selectedTestMethodName = selector.getSelectedTestMethodName();
                Object methodStr = "";
                if (selectedTestMethodName != null && !"".equals(selectedTestMethodName)) {
                    methodStr = "/" + selectedTestMethodName;
                }
                return "./" + selector.getTestSelectorString() + (String)methodStr + "." + extension;
            }
        };
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        this.processor = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processor.doGet(req, resp, null);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processor.doPost(req, resp);
    }
}

