/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Value;
import relocated_for_contentpackage.javax.jcr.ValueFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.commons.webdav.QueryUtil;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.IdFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.NodeId;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QValue;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QValueFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QueryResultRow;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.name.NameConstants;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.value.ValueFormat;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.MultiStatusResponse;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.property.DavProperty;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.property.DavPropertyName;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.property.DavPropertySet;

public class QueryResultRowImpl
implements QueryResultRow {
    private static final Logger log = LoggerFactory.getLogger(QueryResultRowImpl.class);
    private static final DavPropertyName SEARCH_RESULT_PROPERTY = DavPropertyName.create("search-result-property", ItemResourceConstants.NAMESPACE);
    private final Map<String, NodeId> nodeIds = new HashMap<String, NodeId>();
    private final Map<String, Double> scores = new HashMap<String, Double>();
    private final Map<String, QValue> qValues = new HashMap<String, QValue>();
    private final String[] columnNames;

    public QueryResultRowImpl(MultiStatusResponse response, String[] columnNames, NamePathResolver resolver, QValueFactory qValueFactory, ValueFactory valueFactory, IdFactory idFactory) throws RepositoryException {
        this.columnNames = columnNames;
        DavPropertySet okSet = response.getProperties(200);
        String jcrPath = resolver.getJCRName(NameConstants.JCR_PATH);
        String jcrScore = resolver.getJCRName(NameConstants.JCR_SCORE);
        DavProperty<?> davProp = okSet.get(SEARCH_RESULT_PROPERTY);
        ArrayList<String> colList = new ArrayList<String>();
        ArrayList<String> selList = new ArrayList<String>();
        ArrayList<Value> valList = new ArrayList<Value>();
        QueryUtil.parseResultPropertyValue(davProp.getValue(), colList, selList, valList, valueFactory);
        String[] names = colList.toArray(new String[colList.size()]);
        Value[] values = valList.toArray(new Value[valList.size()]);
        for (int i = 0; i < values.length; ++i) {
            try {
                QValue v;
                String selectorName = (String)selList.get(i);
                QValue qValue = v = values[i] == null ? null : ValueFormat.getQValue(values[i], resolver, qValueFactory);
                if (jcrScore.equals(names[i])) {
                    Double score = 0.0;
                    if (v != null) {
                        score = v.getDouble();
                    }
                    this.scores.put(selectorName, score);
                } else if (jcrPath.equals(names[i])) {
                    NodeId id = null;
                    if (v != null) {
                        id = idFactory.createNodeId((String)null, v.getPath());
                    }
                    this.nodeIds.put(selectorName, id);
                }
                this.qValues.put(names[i], v);
                continue;
            }
            catch (RepositoryException e) {
                log.error("Malformed value: " + values[i].toString());
            }
        }
    }

    @Override
    public NodeId getNodeId(String selectorName) {
        if (selectorName == null && this.scores.size() == 1) {
            return this.nodeIds.values().iterator().next();
        }
        NodeId id = this.nodeIds.get(selectorName);
        if (id == null && !this.nodeIds.containsKey(selectorName)) {
            throw new IllegalArgumentException(selectorName + " is not a valid selectorName");
        }
        return id;
    }

    @Override
    public double getScore(String selectorName) {
        if (selectorName == null && this.scores.size() == 1) {
            return this.scores.values().iterator().next();
        }
        Double score = this.scores.get(selectorName);
        if (score == null && !this.nodeIds.containsKey(selectorName)) {
            throw new IllegalArgumentException(selectorName + " is not a valid selectorName");
        }
        return score;
    }

    @Override
    public QValue[] getValues() {
        QValue[] values = new QValue[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            values[i] = this.qValues.get(this.columnNames[i]);
        }
        return values;
    }
}

