/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import java.util.Map;
import org.ops4j.peaberry.Export;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceWatcher;
import org.ops4j.peaberry.builders.ImportDecorator;
import org.ops4j.peaberry.util.DelegatingImport;
import org.ops4j.peaberry.util.SimpleExport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DecoratedServiceWatcher<S>
implements ServiceWatcher<S> {
    private final ImportDecorator<? super S> decorator;
    private final ServiceWatcher<? super S> watcher;

    DecoratedServiceWatcher(ImportDecorator<? super S> decorator, ServiceWatcher<? super S> watcher) {
        this.decorator = decorator;
        this.watcher = watcher;
    }

    @Override
    public <T extends S> Export<T> add(Import<T> service) {
        SimpleExport<T> original = new SimpleExport<T>(service);
        Import<T> decorated = this.decorator.decorate(original);
        Export<T> published = this.watcher.add(decorated);
        if (null == published) {
            return null;
        }
        return new DecoratedExport<T>(original, decorated, published);
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof DecoratedServiceWatcher) {
            DecoratedServiceWatcher decoratedWatcher = (DecoratedServiceWatcher)rhs;
            return this.decorator.equals(decoratedWatcher.decorator) && this.watcher.equals(decoratedWatcher.watcher);
        }
        return false;
    }

    public int hashCode() {
        return this.decorator.hashCode() ^ this.watcher.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DecoratedExport<T>
    extends DelegatingImport<T>
    implements Export<T> {
        private final Export<T> original;
        private final Import<T> decorated;
        private final Export<T> published;

        DecoratedExport(Export<T> original, Import<T> decorated, Export<T> published) {
            super(original);
            this.original = original;
            this.decorated = decorated;
            this.published = published;
        }

        @Override
        public synchronized void put(T newInstance) {
            this.original.put(newInstance);
            this.published.put(null == newInstance ? null : (Object)this.decorated.get());
        }

        @Override
        public synchronized void attributes(Map<String, ?> attributes) {
            this.original.attributes(attributes);
            this.published.attributes(this.decorated.attributes());
        }

        @Override
        public void unput() {
            this.put(null);
        }
    }
}

