/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl.ipeconfig;

import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OverlayResource
extends AbstractResource {
    private final ResourceResolver resolver;
    private final Resource overlayedResource;
    private final String path;
    private final ResourceMetadata resourceMetadata;

    OverlayResource(Resource resource, String path) {
        this.resolver = resource.getResourceResolver();
        this.overlayedResource = resource;
        this.path = path;
        this.resourceMetadata = OverlayResource.buildMetadata(path);
    }

    private static ResourceMetadata buildMetadata(String path) {
        ResourceMetadata metadata = new ResourceMetadata();
        metadata.setResolutionPath(path);
        return metadata;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    @NotNull
    public String getResourceType() {
        return this.overlayedResource.getResourceType();
    }

    @Nullable
    public String getResourceSuperType() {
        return this.overlayedResource.getResourceSuperType();
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.overlayedResource.getValueMap();
        }
        return (AdapterType)super.adaptTo(type);
    }

    public Resource getOverlayedResource() {
        return this.overlayedResource;
    }
}

