/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import org.apache.sling.commons.metrics.Gauge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ThreadPoolMetricsGauges {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolMetricsGauges.class);
    private static final List<String> IGNORED_ATTRIBUTES = Collections.singletonList("MaxThreadAge");
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE = new HashMap();
    private static final Map<Class<?>, Object> CLASS_TO_DEFAULT_VALUE;

    private ThreadPoolMetricsGauges() {
    }

    private static boolean isTypeOfClassOrPrimitive(MBeanAttributeInfo attr, Class<?> clazz) {
        if (clazz.getName().equals(attr.getType())) {
            return true;
        }
        Class<?> primitive = WRAPPER_TO_PRIMITIVE.get(clazz);
        return primitive != null && primitive.getName().equals(attr.getType());
    }

    private static <T> Gauge<T> createGauge(final DynamicMBean bean, final String name, final Object defaultValue) {
        return new Gauge<T>(){

            public T getValue() {
                try {
                    return bean.getAttribute(name);
                }
                catch (Exception e) {
                    LOGGER.warn("cannot obtain MBean attribute named " + name, (Throwable)e);
                    return defaultValue;
                }
            }
        };
    }

    public static Map<String, Gauge<?>> create(DynamicMBean bean) {
        HashMap gauges = new HashMap();
        for (MBeanAttributeInfo attr : bean.getMBeanInfo().getAttributes()) {
            String name = attr.getName();
            if (IGNORED_ATTRIBUTES.contains(name)) {
                LOGGER.debug("ignoring MBean attribute {}", (Object)name);
                continue;
            }
            boolean gaugeForAttributeCreated = false;
            Set<Class<?>> supportedClasses = CLASS_TO_DEFAULT_VALUE.keySet();
            for (Class<?> clazz : supportedClasses) {
                if (!ThreadPoolMetricsGauges.isTypeOfClassOrPrimitive(attr, clazz)) continue;
                gauges.put(name, ThreadPoolMetricsGauges.createGauge(bean, name, CLASS_TO_DEFAULT_VALUE.get(clazz)));
                gaugeForAttributeCreated = true;
            }
            if (gaugeForAttributeCreated) continue;
            LOGGER.warn("no gauge for attribute {} created as type {} is not supported", (Object)name, (Object)attr.getType());
        }
        return gauges;
    }

    static {
        WRAPPER_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        CLASS_TO_DEFAULT_VALUE = new HashMap();
        CLASS_TO_DEFAULT_VALUE.put(Integer.class, -1);
        CLASS_TO_DEFAULT_VALUE.put(Long.class, -1L);
        CLASS_TO_DEFAULT_VALUE.put(Boolean.class, false);
        CLASS_TO_DEFAULT_VALUE.put(String.class, "");
    }
}

