/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.shared.Identifiers;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.referencing.GeodeticException;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.ConversionKeys;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.referencing.CC_Conversion;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

@XmlType(name="AbstractGeneralDerivedCRSType")
@XmlRootElement(name="AbstractGeneralDerivedCRS")
@XmlSeeAlso(value={DefaultDerivedCRS.class, DefaultProjectedCRS.class})
abstract class AbstractDerivedCRS<C extends Conversion>
extends AbstractCRS
implements GeneralDerivedCRS {
    private static final long serialVersionUID = -175151161496419854L;
    private C conversionFromBase;

    AbstractDerivedCRS(Map<String, ?> properties, SingleCRS baseCRS, Conversion baseToDerived, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        super(properties, derivedCS);
        ArgumentChecks.ensureNonNull((String)"baseCRS", (Object)baseCRS);
        ArgumentChecks.ensureNonNull((String)"baseToDerived", (Object)baseToDerived);
        ArgumentChecks.ensureDimensionsMatch((String)"baseToDerived", (int)baseCRS.getCoordinateSystem().getDimension(), (int)derivedCS.getDimension(), (MathTransform)baseToDerived.getMathTransform());
        this.conversionFromBase = this.createConversionFromBase(properties, baseCRS, baseToDerived);
    }

    AbstractDerivedCRS(AbstractDerivedCRS<C> original, AbstractCS derivedCS) {
        super(original, null, derivedCS);
        C conversion = original.conversionFromBase;
        this.conversionFromBase = this.createConversionFromBase(null, (SingleCRS)conversion.getSourceCRS(), (Conversion)conversion);
    }

    AbstractDerivedCRS(Map<String, ?> properties, SingleCRS baseCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform baseToDerived, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        super(properties, derivedCS);
        ArgumentChecks.ensureNonNull((String)"baseCRS", (Object)baseCRS);
        ArgumentChecks.ensureNonNull((String)"method", (Object)method);
        ArgumentChecks.ensureNonNull((String)"baseToDerived", (Object)baseToDerived);
        this.conversionFromBase = new DefaultConversion(ConversionKeys.unprefix(properties), (CoordinateReferenceSystem)baseCRS, this, interpolationCRS, method, baseToDerived);
    }

    AbstractDerivedCRS(GeneralDerivedCRS crs) {
        super((CoordinateReferenceSystem)crs);
        this.conversionFromBase = this.createConversionFromBase(null, (SingleCRS)crs.getBaseCRS(), crs.getConversionFromBase());
    }

    private C createConversionFromBase(Map<String, ?> properties, SingleCRS baseCRS, Conversion conversion) {
        MathTransformFactory factory = null;
        if (properties != null) {
            factory = (MathTransformFactory)properties.get("mtFactory");
        }
        try {
            return (C)((Conversion)this.getConversionType().cast(DefaultConversion.castOrCopy(conversion).specialize((CoordinateReferenceSystem)baseCRS, this, factory)));
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(Errors.forProperties(properties).getString((short)59, (Object)"conversion", (Object)conversion.getName()), e);
        }
    }

    abstract Class<C> getConversionType();

    public abstract Datum getDatum();

    @XmlElement(name="conversion", required=true)
    public C getConversionFromBase() {
        return this.conversionFromBase;
    }

    @Override
    final void formatDatum(Formatter formatter) {
        CoordinateReferenceSystem baseCRS = this.getBaseCRS();
        if (baseCRS instanceof AbstractCRS) {
            ((AbstractCRS)baseCRS).formatDatum(formatter);
        } else {
            super.formatDatum(formatter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            if (Semaphores.COMPARING_CONVERSION_OR_DERIVED_CRS.set()) {
                try {
                    Object op2;
                    C op1;
                    if (mode == ComparisonMode.STRICT) {
                        op1 = this.conversionFromBase;
                        op2 = ((AbstractDerivedCRS)object).conversionFromBase;
                    } else {
                        op1 = this.getConversionFromBase();
                        op2 = ((GeneralDerivedCRS)object).getConversionFromBase();
                    }
                    boolean bl = Utilities.deepEquals(op1, op2, (ComparisonMode)mode);
                    return bl;
                }
                finally {
                    Semaphores.COMPARING_CONVERSION_OR_DERIVED_CRS.clear();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.conversionFromBase.getSourceCRS().hashCode()) + (long)(37 * this.conversionFromBase.getMathTransform().hashCode());
    }

    AbstractDerivedCRS() {
    }

    private void setConversionFromBase(C conversion) {
        if (this.conversionFromBase == null) {
            this.conversionFromBase = conversion;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractDerivedCRS.class, (String)"setConversionFromBase", (String)"conversion");
        }
    }

    final void setBaseCRS(String name, SingleCRS baseCRS) {
        if (this.conversionFromBase != null) {
            SingleCRS previous = CC_Conversion.setBaseCRS(this.conversionFromBase, baseCRS);
            if (previous != null) {
                CC_Conversion.setBaseCRS(this.conversionFromBase, previous);
                ImplementationHelper.propertyAlreadySet(AbstractDerivedCRS.class, (String)"setBaseCRS", (String)name);
            }
        } else {
            throw new IllegalStateException(Errors.format((short)106, this.getInterface(), (Object)"conversion"));
        }
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        String property = "conversion";
        if (this.conversionFromBase != null) {
            SingleCRS baseCRS = CC_Conversion.setBaseCRS(this.conversionFromBase, null);
            property = "coordinateSystem";
            if (super.getCoordinateSystem() != null) {
                property = "baseCRS";
                if (baseCRS != null) {
                    this.conversionFromBase = this.createConversionFromBase(null, baseCRS, (Conversion)this.conversionFromBase);
                    return;
                }
            }
        }
        throw new GeodeticException(Identifiers.missingValueForProperty((Identifier)this.getName(), (String)property));
    }
}

