/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.internal.shared.RangeArgument;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.MemoryGridCoverageResource;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.storage.aggregate.ConcatenatedGridCoverage;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.storage.aggregate.GridSliceLocator;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.Containers;
import org.opengis.referencing.operation.TransformException;

final class ConcatenatedGridResource
extends AggregatedResource
implements GridCoverageResource {
    private final List<SampleDimension> sampleDimensions;
    final boolean isConverted;
    private BitSet deferredLoading;
    final GridSliceLocator locator;
    final MergeStrategy mergeStrategy;
    private final GridCoverageProcessor processor;
    private double[][] resolutions;

    ConcatenatedGridResource(String name, StoreListeners listeners, List<SampleDimension> ranges, GridSliceLocator locator, MergeStrategy strategy, GridCoverageProcessor processor) {
        super(name, listeners, false);
        this.sampleDimensions = ranges;
        this.locator = locator;
        this.mergeStrategy = strategy;
        this.processor = processor;
        this.deferredLoading = new BitSet();
        for (SampleDimension sd : ranges) {
            if (sd.forConvertedValues(true) == sd) continue;
            this.isConverted = false;
            return;
        }
        this.isConverted = true;
    }

    private ConcatenatedGridResource(ConcatenatedGridResource source, MergeStrategy strategy) {
        super(source);
        this.sampleDimensions = source.sampleDimensions;
        this.isConverted = source.isConverted;
        this.deferredLoading = source.deferredLoading;
        this.locator = source.locator;
        this.processor = source.processor;
        this.resolutions = source.resolutions;
        this.mergeStrategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final Resource apply(MergeStrategy s) {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (Objects.equals(this.mergeStrategy, s)) {
                return this;
            }
            return new ConcatenatedGridResource(this, s);
        }
    }

    @Override
    final List<Resource> components() {
        GridSlice[] slices = this.locator.slices;
        Object[] resources = new GridCoverageResource[slices.length];
        for (int i = 0; i < resources.length; ++i) {
            resources[i] = slices[i].resource;
        }
        return Containers.viewAsUnmodifiableList((Object[])resources);
    }

    @Override
    protected void createMetadata(MetadataBuilder builder) throws DataStoreException {
        builder.addDefaultMetadata(this, this.listeners);
    }

    @Override
    public final GridGeometry getGridGeometry() {
        return this.locator.gridGeometry;
    }

    @Override
    public final List<SampleDimension> getSampleDimensions() {
        return this.sampleDimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<double[]> getResolutions() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.resolutions == null) {
                GridSlice[] slices = this.locator.slices;
                GridCoverageResource[] resources = new GridCoverageResource[slices.length];
                for (int i = 0; i < resources.length; ++i) {
                    resources[i] = slices[i].resource;
                }
                this.resolutions = ConcatenatedGridResource.commonResolutions(resources);
            }
            return Containers.viewAsUnmodifiableList((Object[])this.resolutions);
        }
    }

    static double[][] commonResolutions(GridCoverageResource[] sources) throws DataStoreException {
        int count = 0;
        double[][] resolutions = null;
        for (GridCoverageResource slice : sources) {
            double[][] sr = (double[][])slice.getResolutions().toArray(x$0 -> new double[x$0][]);
            if (sr == null) continue;
            if (resolutions == null) {
                resolutions = sr;
                count = sr.length;
                continue;
            }
            int retained = 0;
            block1: for (int i = 0; i < count; ++i) {
                double[] r = resolutions[i];
                for (int j = 0; j < sr.length; ++j) {
                    if (!Arrays.equals(r, sr[j])) continue;
                    resolutions[retained++] = r;
                    sr[j] = null;
                    continue block1;
                }
            }
            count = retained;
            if (count == 0) break;
        }
        return (double[][])ArraysExt.resize(resolutions, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        RasterLoadingStrategy conservative = RasterLoadingStrategy.AT_GET_TILE_TIME;
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            for (GridSlice slice : this.locator.slices) {
                RasterLoadingStrategy s;
                if (ConcatenatedGridResource.ignore(slice.resource) || (s = slice.resource.getLoadingStrategy()).ordinal() >= conservative.ordinal()) continue;
                conservative = s;
                if (s.ordinal() == 0) break;
            }
        }
        return conservative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        boolean deferred = strategy != RasterLoadingStrategy.AT_READ_TIME;
        BitSet newValues = new BitSet();
        boolean accepted = true;
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            int i = this.locator.slices.length;
            while (--i >= 0) {
                GridCoverageResource slice = this.locator.slices[i].resource;
                if (slice.setLoadingStrategy(strategy) || ConcatenatedGridResource.ignore(slice)) continue;
                if (deferred && slice.getLoadingStrategy() == RasterLoadingStrategy.AT_READ_TIME) {
                    newValues.set(i);
                    continue;
                }
                accepted = false;
            }
            if (!this.deferredLoading.equals(newValues)) {
                this.deferredLoading = newValues;
            }
        }
        return accepted;
    }

    private static boolean ignore(GridCoverageResource slice) {
        return slice instanceof MemoryGridCoverageResource;
    }

    private boolean isDeferred(int sliceIndex) {
        return this.deferredLoading.get(sliceIndex);
    }

    private static long[] subsampling(GridDerivation subgrid) {
        long[] subsampling;
        for (long s : subsampling = subgrid.getSubsampling()) {
            if (s == 1L) continue;
            return subsampling;
        }
        return null;
    }

    @Override
    public GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        int i;
        int[] selection;
        GridExtent areaOfInterest;
        long[] subsampling;
        if (ranges != null) {
            ranges = RangeArgument.validate((int)this.sampleDimensions.size(), (int[])ranges, (Localized)this.listeners).getSelectedBands();
        }
        GridGeometry gridGeometry = this.getGridGeometry();
        if (domain != null) {
            GridDerivation subgrid = gridGeometry.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(domain);
            domain = subgrid.build();
            subsampling = ConcatenatedGridResource.subsampling(subgrid);
            areaOfInterest = subgrid.getIntersection();
            selection = this.locator.find(areaOfInterest);
        } else {
            domain = gridGeometry;
            subsampling = null;
            areaOfInterest = null;
            selection = ArraysExt.range((int)0, (int)this.locator.slices.length);
        }
        switch (selection.length) {
            case 0: {
                throw new DisjointExtentException(gridGeometry.getExtent(), domain.getExtent(), this.locator.searchDimension);
            }
            case 1: {
                int sliceIndex = selection[0];
                if (this.isDeferred(sliceIndex)) break;
                return this.locator.slices[sliceIndex].resource.read(domain, ranges);
            }
        }
        boolean full = domain.equals((Object)gridGeometry, ComparisonMode.IGNORE_METADATA);
        Object[] selected = new GridSlice[selection.length];
        GridCoverage[] coverages = null;
        long[] actualSubsampling = null;
        for (i = 0; i < selection.length; ++i) {
            GridDerivation subgrid;
            long[] candidate;
            GridCoverage coverage;
            int sliceIndex = selection[i];
            GridSlice slice = this.locator.slices[sliceIndex];
            selected[i] = slice;
            if (full && this.isDeferred(sliceIndex)) continue;
            if (coverages == null) {
                coverages = new GridCoverage[selection.length];
            }
            coverages[i] = coverage = slice.resource.read(domain, ranges);
            if (subsampling == null || (candidate = ConcatenatedGridResource.subsampling(subgrid = gridGeometry.derive().subgrid(coverage.getGridGeometry()))) == null) continue;
            if (actualSubsampling == null) {
                actualSubsampling = candidate;
                continue;
            }
            for (int j = 0; j < actualSubsampling.length; ++j) {
                actualSubsampling[j] = Math.max(actualSubsampling[j], candidate[j]);
            }
        }
        if (!Arrays.equals(subsampling, actualSubsampling)) {
            GridDerivation subgrid = gridGeometry.derive().subgrid(areaOfInterest, actualSubsampling);
            domain = subgrid.build();
        }
        if (coverages != null) {
            try {
                for (i = 0; i < selected.length; ++i) {
                    void coverage = coverages[i];
                    if (coverage == null) continue;
                    GridGeometry geometry = coverage.getGridGeometry();
                    GridExtent inGroup = domain.extentOf(geometry, GridSlice.CELL_ANCHOR, GridRoundingMode.NEAREST);
                    MemoryGridCoverageResource resource = new MemoryGridCoverageResource(this, null, (GridCoverage)coverage, this.processor);
                    selected[i] = ((GridSlice)selected[i]).resolve(resource, geometry.getExtent(), inGroup);
                }
            }
            catch (TransformException e) {
                throw new DataStoreReferencingException(e);
            }
        }
        GridSliceLocator subset = this.locator;
        if (!Arrays.equals(selected, subset.slices)) {
            subset = new GridSliceLocator(domain, (GridSlice[])selected, this.locator.searchDimension);
        }
        return new ConcatenatedGridCoverage(this, subset, ranges);
    }
}

