/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.writer;

import java.io.IOException;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.UpdatableWrite;

public abstract class TagValue {
    private UpdatableWrite<?> offset;

    protected abstract void write(ChannelDataOutput var1) throws IOException;

    public final void mark(UpdatableWrite<?> offset) {
        this.offset = offset;
    }

    public final void markAndWrite(ChannelDataOutput output) throws IOException {
        this.offset = UpdatableWrite.of((ChannelDataOutput)output);
        this.write(output);
    }

    public final UpdatableWrite<?> writeHere(ChannelDataOutput output) throws IOException {
        this.offset.setAsLong(output.getStreamPosition());
        boolean done = this.offset.tryUpdateBuffer(output);
        this.write(output);
        return done ? null : this.offset;
    }

    final void rewrite(ChannelDataOutput output) throws IOException {
        output.seek(this.offset.getAsLong().orElse(this.offset.position));
        this.write(output);
    }
}

