/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.util.Callback;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.RenderingTask;
import org.apache.sis.image.internal.shared.ColorModelFactory;

public abstract class MapCanvasAWT
extends MapCanvas {
    private static final boolean NATIVE_ACCELERATION = false;
    private static final int WARNING_SIZE = 200;
    private static final String WARNING_TEXT = "\u26a0";
    private static final Insets DEFAULT_MARGIN = new Insets(40.0);
    public final ObjectProperty<Insets> imageMargin = new SimpleObjectProperty((Object)this, "imageMargin", (Object)DEFAULT_MARGIN);
    private BufferedImage buffer;
    private VolatileImage doubleBuffer;
    private GraphicsConfiguration bufferConfiguration;
    private PixelBuffer<IntBuffer> bufferWrapper;
    protected final ImageView image = new ImageView();
    private boolean isWarningShown;

    public MapCanvasAWT(Locale locale) {
        super(locale);
        this.image.setPreserveRatio(true);
        this.floatingPane.getChildren().add((Object)this.image);
    }

    @Override
    final Bounds getBoundsInParent() {
        return this.image.getBoundsInParent();
    }

    private void clearBuffer() {
        this.buffer = null;
        this.doubleBuffer = null;
        this.bufferWrapper = null;
        this.bufferConfiguration = null;
    }

    @Override
    protected abstract Renderer createRenderer();

    @Override
    final RenderingTask<?> createWorker(MapCanvas.Renderer mc) {
        assert (Platform.isFxApplicationThread());
        Renderer context = (Renderer)mc;
        if (!context.isValid((Insets)this.imageMargin.get(), this.buffer)) {
            this.clearBuffer();
            return new Creator(context);
        }
        return new Updater(context);
    }

    private void clearWarning() {
        if (this.isWarningShown) {
            this.isWarningShown = false;
            this.setNavigationDisabled(false);
        }
    }

    @Override
    protected void clear() {
        this.image.setImage(null);
        this.clearBuffer();
        super.clear();
    }

    protected static abstract class Renderer
    extends MapCanvas.Renderer {
        private int left;
        private int top;
        private int width;
        private int height;

        protected Renderer() {
        }

        private static int clamp(double value) {
            return (int)Math.max(0L, Math.min(32767L, Math.round(value)));
        }

        private boolean isValid(Insets margin, BufferedImage buffer) {
            this.width = this.getWidth();
            this.height = this.getHeight();
            if (margin != null) {
                this.top = Renderer.clamp(margin.getTop());
                int right = Renderer.clamp(margin.getRight());
                int bottom = Renderer.clamp(margin.getBottom());
                this.left = Renderer.clamp(margin.getLeft());
                this.width = Math.addExact(this.width, this.left + right);
                this.height = Math.addExact(this.height, this.top + bottom);
            }
            return buffer != null && buffer.getWidth() == this.width && buffer.getHeight() == this.height;
        }

        private void translate(Graphics2D gr) {
            gr.translate(this.left, this.top);
        }

        private void translate(ImageView image) {
            image.setTranslateX((double)(-this.left));
            image.setTranslateY((double)(-this.top));
        }

        @Override
        protected void render() throws Exception {
        }

        protected abstract void paint(Graphics2D var1);

        @Override
        protected boolean commit(MapCanvas canvas) {
            return true;
        }
    }

    private final class Creator
    extends RenderingTask<WritableImage> {
        private final Renderer renderer;
        private BufferedImage drawTo;
        private PixelBuffer<IntBuffer> wrapper;
        private GraphicsConfiguration configuration;

        Creator(Renderer context) {
            this.renderer = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WritableImage call() throws Exception {
            this.renderer.render();
            int width = this.renderer.width;
            int height = this.renderer.height;
            this.drawTo = new BufferedImage(width, height, 3);
            Graphics2D gr = this.drawTo.createGraphics();
            try {
                this.configuration = gr.getDeviceConfiguration();
                this.renderer.translate(gr);
                this.renderer.paint(gr);
            }
            finally {
                gr.dispose();
            }
            DataBufferInt array = (DataBufferInt)this.drawTo.getRaster().getDataBuffer();
            IntBuffer ib = IntBuffer.wrap(array.getData(), array.getOffset(), array.getSize());
            this.wrapper = new PixelBuffer(width, height, (Buffer)ib, (PixelFormat)PixelFormat.getIntArgbPreInstance());
            return new WritableImage(this.wrapper);
        }

        protected void succeeded() {
            MapCanvasAWT.this.image.setImage((Image)this.getValue());
            this.renderer.translate(MapCanvasAWT.this.image);
            MapCanvasAWT.this.buffer = this.drawTo;
            MapCanvasAWT.this.bufferWrapper = this.wrapper;
            MapCanvasAWT.this.bufferConfiguration = this.configuration;
            boolean done = this.renderer.commit(MapCanvasAWT.this);
            MapCanvasAWT.this.clearWarning();
            MapCanvasAWT.this.renderingCompleted(this);
            if (!done || MapCanvasAWT.this.contentsChanged()) {
                MapCanvasAWT.this.repaint();
            }
        }

        protected void failed() {
            MapCanvasAWT.this.renderingCompleted(this);
        }

        protected void cancelled() {
            MapCanvasAWT.this.renderingCompleted(this);
        }
    }

    private final class Updater
    extends RenderingTask<VolatileImage>
    implements Callback<PixelBuffer<IntBuffer>, Rectangle2D> {
        private final Renderer renderer;
        private VolatileImage previousBuffer;
        private final GraphicsConfiguration configuration;
        private boolean contentsLost;

        Updater(Renderer context) {
            this.renderer = context;
            this.previousBuffer = MapCanvasAWT.this.doubleBuffer;
            this.configuration = MapCanvasAWT.this.bufferConfiguration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected VolatileImage call() throws Exception {
            this.renderer.render();
            int width = this.renderer.width;
            int height = this.renderer.height;
            VolatileImage drawTo = this.previousBuffer;
            this.previousBuffer = null;
            if (drawTo == null) {
                drawTo = this.configuration.createCompatibleVolatileImage(width, height, 3);
            }
            boolean invalid = true;
            try {
                do {
                    if (drawTo.validate(this.configuration) == 2) {
                        drawTo = this.configuration.createCompatibleVolatileImage(width, height, 3);
                    }
                    Graphics2D gr = drawTo.createGraphics();
                    try {
                        gr.setBackground(ColorModelFactory.TRANSPARENT);
                        gr.clearRect(0, 0, drawTo.getWidth(), drawTo.getHeight());
                        this.renderer.translate(gr);
                        this.renderer.paint(gr);
                    }
                    finally {
                        gr.dispose();
                    }
                } while ((invalid = drawTo.contentsLost()) && !this.isCancelled());
            }
            finally {
                if (invalid) {
                    drawTo.flush();
                }
            }
            return drawTo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Rectangle2D call(PixelBuffer<IntBuffer> wrapper) {
            VolatileImage drawTo = MapCanvasAWT.this.doubleBuffer;
            Graphics2D gr = MapCanvasAWT.this.buffer.createGraphics();
            try {
                gr.setComposite(AlphaComposite.Src);
                gr.drawImage(drawTo, 0, 0, null);
                this.contentsLost = drawTo.contentsLost();
            }
            finally {
                gr.dispose();
            }
            return null;
        }

        protected void succeeded() {
            final Scene scene = MapCanvasAWT.this.fixedPane.getScene();
            if (scene != null) {
                Runnable pulseAction = new Runnable(){
                    final /* synthetic */ Updater this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        scene.removePreLayoutPulseListener((Runnable)this);
                        this.this$1.transferImage();
                    }
                };
                scene.addPreLayoutPulseListener(pulseAction);
                Platform.requestNextPulse();
            } else {
                this.transferImage();
            }
        }

        private void transferImage() {
            VolatileImage drawTo;
            MapCanvasAWT.this.doubleBuffer = drawTo = (VolatileImage)this.getValue();
            try {
                MapCanvasAWT.this.bufferWrapper.updateBuffer((Callback)this);
            }
            finally {
                drawTo.flush();
            }
            this.renderer.translate(MapCanvasAWT.this.image);
            boolean done = this.renderer.commit(MapCanvasAWT.this);
            MapCanvasAWT.this.clearWarning();
            MapCanvasAWT.this.renderingCompleted(this);
            if (!done || this.contentsLost || MapCanvasAWT.this.contentsChanged()) {
                MapCanvasAWT.this.repaint();
            }
        }

        protected void cancelled() {
            this.failed();
        }

        protected void failed() {
            if (!MapCanvasAWT.this.isWarningShown) {
                int rw = this.renderer.getWidth();
                int rh = this.renderer.getHeight();
                int x = Math.max((rw - 200) / 2, 0);
                int y = Math.max((rh - 200) / 2, 0);
                int width = rw - 2 * x;
                int height = rh - 2 * y;
                Font font = new Font("Serif", 0, height);
                MapCanvasAWT.this.bufferWrapper.updateBuffer(wrapper -> {
                    Graphics2D gr = MapCanvasAWT.this.buffer.createGraphics();
                    try {
                        this.renderer.translate(gr);
                        gr.setColor(new Color(-1602207680, true));
                        gr.fillRoundRect(x, y, width, height, width / 5, height / 5);
                        gr.setColor(Color.RED);
                        GlyphVector glyphs = font.createGlyphVector(gr.getFontRenderContext(), MapCanvasAWT.WARNING_TEXT);
                        java.awt.geom.Rectangle2D vb = glyphs.getVisualBounds();
                        gr.drawGlyphVector(glyphs, (float)((double)x + 0.5 * (double)width - vb.getCenterX()), (float)((double)y + 0.5 * (double)height - vb.getCenterY()));
                    }
                    finally {
                        gr.dispose();
                    }
                    return null;
                });
                MapCanvasAWT.this.isWarningShown = true;
                MapCanvasAWT.this.setNavigationDisabled(true);
            }
            MapCanvasAWT.this.renderingCompleted(this);
        }
    }
}

