/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.channel.EventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.impl.DnsResolverGroupImpl;
import org.apache.pulsar.client.impl.PulsarClientSharedResourcesBuilderImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.client.util.ScheduledExecutorProvider;
import org.apache.pulsar.common.util.netty.EventLoopUtil;

class PulsarClientResourcesConfigurer {
    static final String NAME_TIMER = "pulsar-timer";
    static final String POOL_NAME_LOOKUP_EXECUTOR = "pulsar-client-lookup";
    static final String POOL_NAME_INTERNAL_EXECUTOR = "pulsar-client-internal";
    static final String POOL_NAME_LISTENER_EXECUTOR = "pulsar-external-listener";
    static final String POOL_NAME_SCHEDULED_EXECUTOR = "pulsar-client-scheduled";
    static final String POOL_NAME_EVENT_LOOP_GROUP = "pulsar-client-io";
    static final int LOOKUP_EXECUTOR_NUM_THREADS = 1;

    PulsarClientResourcesConfigurer() {
    }

    static HashedWheelTimer createTimer() {
        return PulsarClientResourcesConfigurer.createTimerInternal(NAME_TIMER, 1L, TimeUnit.MILLISECONDS);
    }

    private static HashedWheelTimer createTimerInternal(String poolName, long tickDuration, TimeUnit timeUnit) {
        return new HashedWheelTimer(PulsarClientResourcesConfigurer.createThreadFactory(poolName), tickDuration, timeUnit);
    }

    static HashedWheelTimer createTimer(PulsarClientSharedResourcesBuilderImpl.TimerResourceConfig resourceConfig) {
        if (resourceConfig == null) {
            resourceConfig = new PulsarClientSharedResourcesBuilderImpl.TimerResourceConfig();
        }
        return PulsarClientResourcesConfigurer.createTimerInternal(resourceConfig.name, resourceConfig.tickDuration, resourceConfig.tickDurationTimeUnit);
    }

    static ExecutorProvider createLookupExecutorProvider() {
        return PulsarClientResourcesConfigurer.createExecutorProviderInternal(1, POOL_NAME_LOOKUP_EXECUTOR);
    }

    static ExecutorProvider createLookupExecutorProviderWithResourceConfig(PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig resourceConfig) {
        return PulsarClientResourcesConfigurer.createExecutorProviderInternal(resourceConfig, POOL_NAME_LOOKUP_EXECUTOR);
    }

    private static ExecutorProvider createExecutorProviderInternal(int numThreads, String poolName) {
        return PulsarClientResourcesConfigurer.createExecutorProviderInternal(numThreads, poolName, Thread.currentThread().isDaemon());
    }

    private static ExecutorProvider createExecutorProviderInternal(int numThreads, String poolName, boolean daemon) {
        return new ExecutorProvider(numThreads, poolName, daemon);
    }

    static ExecutorProvider createInternalExecutorProvider(ClientConfigurationData conf) {
        return PulsarClientResourcesConfigurer.createExecutorProviderInternal(conf.getNumIoThreads(), POOL_NAME_INTERNAL_EXECUTOR);
    }

    static ExecutorProvider createInternalExecutorProviderWithResourceConfig(PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig resourceConfig) {
        return PulsarClientResourcesConfigurer.createExecutorProviderInternal(resourceConfig, POOL_NAME_INTERNAL_EXECUTOR);
    }

    static ExecutorProvider createExternalExecutorProvider(ClientConfigurationData conf) {
        return PulsarClientResourcesConfigurer.createExecutorProviderInternal(conf.getNumListenerThreads(), POOL_NAME_LISTENER_EXECUTOR);
    }

    static ExecutorProvider createExternalExecutorProviderWithResourceConfig(PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig resourceConfig) {
        return PulsarClientResourcesConfigurer.createExecutorProviderInternal(resourceConfig, POOL_NAME_LISTENER_EXECUTOR);
    }

    private static ExecutorProvider createExecutorProviderInternal(PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig resourceConfig, String defaultPoolName) {
        if (resourceConfig == null) {
            resourceConfig = new PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig();
        }
        String poolName = StringUtils.isNotBlank((CharSequence)resourceConfig.name) ? resourceConfig.name : defaultPoolName;
        return PulsarClientResourcesConfigurer.createExecutorProviderInternal(resourceConfig.numberOfThreads, poolName, resourceConfig.daemon);
    }

    static ScheduledExecutorProvider createScheduledExecutorProvider(ClientConfigurationData conf) {
        return new ScheduledExecutorProvider(conf.getNumIoThreads(), POOL_NAME_SCHEDULED_EXECUTOR);
    }

    static ScheduledExecutorProvider createScheduledExecutorProviderWithResourceConfig(PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig resourceConfig) {
        if (resourceConfig == null) {
            resourceConfig = new PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig();
        }
        String poolName = StringUtils.isNotBlank((CharSequence)resourceConfig.name) ? resourceConfig.name : POOL_NAME_SCHEDULED_EXECUTOR;
        return new ScheduledExecutorProvider(resourceConfig.numberOfThreads, poolName, resourceConfig.daemon);
    }

    static EventLoopGroup createEventLoopGroup(ClientConfigurationData conf) {
        ThreadFactory threadFactory = PulsarClientResourcesConfigurer.createThreadFactory(POOL_NAME_EVENT_LOOP_GROUP);
        return EventLoopUtil.newEventLoopGroup((int)conf.getNumIoThreads(), (boolean)conf.isEnableBusyWait(), (ThreadFactory)threadFactory);
    }

    static EventLoopGroup createEventLoopGroupWithResourceConfig(PulsarClientSharedResourcesBuilderImpl.EventLoopResourceConfig eventLoopResourceConfig) {
        if (eventLoopResourceConfig == null) {
            eventLoopResourceConfig = new PulsarClientSharedResourcesBuilderImpl.EventLoopResourceConfig();
        }
        ThreadFactory threadFactory = PulsarClientResourcesConfigurer.createThreadFactory(eventLoopResourceConfig.name, eventLoopResourceConfig.daemon);
        return EventLoopUtil.newEventLoopGroup((int)eventLoopResourceConfig.numberOfThreads, (boolean)eventLoopResourceConfig.enableBusyWait, (ThreadFactory)threadFactory);
    }

    static ThreadFactory createThreadFactory(String poolName) {
        return PulsarClientResourcesConfigurer.createThreadFactory(poolName, Thread.currentThread().isDaemon());
    }

    static ThreadFactory createThreadFactory(String poolName, boolean daemon) {
        return new ExecutorProvider.ExtendedThreadFactory(poolName, daemon);
    }

    static DnsResolverGroupImpl createDnsResolverGroup(ClientConfigurationData conf) {
        return new DnsResolverGroupImpl(conf);
    }

    static DnsResolverGroupImpl createDnsResolverGroupWithResourceConfig(PulsarClientSharedResourcesBuilderImpl.DnsResolverResourceConfig resourceConfig) {
        if (resourceConfig == null) {
            resourceConfig = new PulsarClientSharedResourcesBuilderImpl.DnsResolverResourceConfig();
        }
        return new DnsResolverGroupImpl(resourceConfig);
    }
}

