/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.rewriter.htmlcleaner;

import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.Serializer;

/**
 * Factory interface responsible for creating HtmlCleaner {@link Serializer}.
 * <p>
 * {@link HtmlCleanerContentRewriter} requires an instance of this factory type
 * to create a physical HtmlCleaner {@link Serializer} instance.
 * </p>
 */
public interface SerializerFactory
{
    /**
     * Creates a {@link Serializer} instance for the given HtmlCleaner instance.
     * <p>
     * <em>Note: </em>
     * Implementations can read properties of the given HtmlCleaner instance
     * to set configurations of the newly created {@link Serializer} instance
     * like {@link org.apache.portals.applications.webcontent2.rewriter.htmlcleaner.DefaultSerializerFactory} does.
     * </p>
     * @param cleaner
     * @return
     * @throws Exception
     */
    public Serializer createSerializer(HtmlCleaner cleaner) throws Exception;
}
