/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.timebuffer;

public class TimestampedLongAggregation {
    private final Long value;
    private final long timestamp;
    private final TimestampedAggregation cumulation;

    public TimestampedLongAggregation(long value) {
        this.value = value;
        this.timestamp = System.currentTimeMillis();
        this.cumulation = null;
    }

    public TimestampedLongAggregation(TimestampedAggregation cumulation) {
        this.value = null;
        this.timestamp = System.currentTimeMillis();
        this.cumulation = cumulation;
    }

    public TimestampedAggregation getAggregation() {
        if (this.cumulation != null) {
            return this.cumulation;
        }
        return new TimestampedAggregation(this.value, this.value, this.value, 1L);
    }

    public Long getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static TimestampedLongAggregation newValue(long value) {
        return new TimestampedLongAggregation(value);
    }

    public static TimestampedLongAggregation newAggregation(TimestampedAggregation cumulation) {
        return new TimestampedLongAggregation(cumulation);
    }

    public static class TimestampedAggregation {
        private final long min;
        private final long max;
        private final long sum;
        private final long count;

        public TimestampedAggregation(long min, long max, long sum, long count) {
            this.min = min;
            this.max = max;
            this.sum = sum;
            this.count = count;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public long getSum() {
            return this.sum;
        }

        public long getCount() {
            return this.count;
        }

        public TimestampedAggregation add(TimestampedAggregation aggregation) {
            return new TimestampedAggregation(Math.min(this.min, aggregation.min), Math.max(this.max, aggregation.max), this.sum + aggregation.sum, this.count + aggregation.count);
        }
    }
}

